rule win_flame_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.flame."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flame"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c9 741a 83f901 7415 e8???????? }
            // n = 5, score = 400
            //   85c9                 | test                ecx, ecx
            //   741a                 | je                  0x1c
            //   83f901               | cmp                 ecx, 1
            //   7415                 | je                  0x17
            //   e8????????           |                     

        $sequence_1 = { 7426 488d4def e8???????? 90 }
            // n = 4, score = 200
            //   7426                 | mov                 eax, dword ptr [ebp - 0x30]
            //   488d4def             | dec                 eax
            //   e8????????           |                     
            //   90                   | sub                 ecx, dword ptr [ebx]

        $sequence_2 = { 7424 448865dc 41c1ec08 488d55dc }
            // n = 4, score = 200
            //   7424                 | lea                 eax, [ebp - 0x18]
            //   448865dc             | je                  0x28
            //   41c1ec08             | dec                 eax
            //   488d55dc             | cmp                 edx, 0x18

        $sequence_3 = { 395d0c 0f84e6020000 3bc3 0f84f7020000 83f803 7251 8b4648 }
            // n = 7, score = 200
            //   395d0c               | cmp                 dword ptr [ebp + 0xc], ebx
            //   0f84e6020000         | je                  0x2ec
            //   3bc3                 | cmp                 eax, ebx
            //   0f84f7020000         | je                  0x2fd
            //   83f803               | cmp                 eax, 3
            //   7251                 | jb                  0x53
            //   8b4648               | mov                 eax, dword ptr [esi + 0x48]

        $sequence_4 = { 7426 4883fa18 7420 4883fa20 }
            // n = 4, score = 200
            //   7426                 | dec                 eax
            //   4883fa18             | cmp                 ecx, eax
            //   7420                 | je                  0x26
            //   4883fa20             | dec                 eax

        $sequence_5 = { 833e0b 7506 c7060c000000 8b420c 8b4a10 8365dc00 }
            // n = 6, score = 200
            //   833e0b               | cmp                 dword ptr [esi], 0xb
            //   7506                 | jne                 8
            //   c7060c000000         | mov                 dword ptr [esi], 0xc
            //   8b420c               | mov                 eax, dword ptr [edx + 0xc]
            //   8b4a10               | mov                 ecx, dword ptr [edx + 0x10]
            //   8365dc00             | and                 dword ptr [ebp - 0x24], 0

        $sequence_6 = { 894678 8b4670 894664 c7466002000000 3bd3 7476 }
            // n = 6, score = 200
            //   894678               | mov                 dword ptr [esi + 0x78], eax
            //   8b4670               | mov                 eax, dword ptr [esi + 0x70]
            //   894664               | mov                 dword ptr [esi + 0x64], eax
            //   c7466002000000       | mov                 dword ptr [esi + 0x60], 2
            //   3bd3                 | cmp                 edx, ebx
            //   7476                 | je                  0x78

        $sequence_7 = { c645fc01 85c9 740a ff7508 e8???????? eb02 33c0 }
            // n = 7, score = 200
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   85c9                 | test                ecx, ecx
            //   740a                 | je                  0xc
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 85c0 7423 8b5500 498bcd }
            // n = 4, score = 200
            //   85c0                 | dec                 eax
            //   7423                 | cmp                 ecx, eax
            //   8b5500               | jne                 0x26
            //   498bcd               | dec                 esp

        $sequence_9 = { 7424 488b0b 4533c9 448bc6 488bd5 48897c2428 }
            // n = 6, score = 200
            //   7424                 | je                  0x26
            //   488b0b               | dec                 eax
            //   4533c9               | mov                 ecx, dword ptr [ebx]
            //   448bc6               | inc                 ebp
            //   488bd5               | xor                 ecx, ecx
            //   48897c2428           | inc                 esp

        $sequence_10 = { 8b90b0000000 4903d3 eb64 448bc0 }
            // n = 4, score = 200
            //   8b90b0000000         | inc                 esp
            //   4903d3               | mov                 byte ptr [ebp - 0x24], ah
            //   eb64                 | inc                 ecx
            //   448bc0               | shr                 esp, 8

        $sequence_11 = { 50 e8???????? 59 895e0c 885dfc 8b4604 3bc3 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   895e0c               | mov                 dword ptr [esi + 0xc], ebx
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   3bc3                 | cmp                 eax, ebx

        $sequence_12 = { 8365fc00 8b4d08 c700???????? 89480c 834dfcff 8b4df4 }
            // n = 6, score = 200
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   c700????????         |                     
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_13 = { 56 8b7006 85f6 7525 50 8d4dc8 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   8b7006               | mov                 esi, dword ptr [eax + 6]
            //   85f6                 | test                esi, esi
            //   7525                 | jne                 0x27
            //   50                   | push                eax
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]

        $sequence_14 = { 7424 488b4b08 8b45d0 482b0b }
            // n = 4, score = 200
            //   7424                 | mov                 ecx, dword ptr [ebx]
            //   488b4b08             | inc                 ebp
            //   8b45d0               | xor                 ecx, ecx
            //   482b0b               | inc                 esp

    condition:
        7 of them and filesize < 1676288
}