rule win_flashflood_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.flashflood."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flashflood"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b35???????? 8d85f0fdffff 6a2e 50 ffd6 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b35????????         |                     
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   6a2e                 | push                0x2e
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_1 = { 50 ff5118 8b45f0 8b4dcc 8345e00c 3b08 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   ff5118               | call                dword ptr [ecx + 0x18]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   8345e00c             | add                 dword ptr [ebp - 0x20], 0xc
            //   3b08                 | cmp                 ecx, dword ptr [eax]

        $sequence_2 = { 83c428 6a00 6840420f00 ff75dc ff75d8 e8???????? }
            // n = 6, score = 100
            //   83c428               | add                 esp, 0x28
            //   6a00                 | push                0
            //   6840420f00           | push                0xf4240
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   e8????????           |                     

        $sequence_3 = { c3 33d2 39542408 7e24 53 8b442408 8d0c02 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   33d2                 | xor                 edx, edx
            //   39542408             | cmp                 dword ptr [esp + 8], edx
            //   7e24                 | jle                 0x26
            //   53                   | push                ebx
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   8d0c02               | lea                 ecx, [edx + eax]

        $sequence_4 = { c3 55 8bec 81ece8050000 8365fc00 6a00 e8???????? }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ece8050000         | sub                 esp, 0x5e8
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_5 = { 0fb745e4 50 8d8518fdffff 68???????? 50 ffd6 }
            // n = 6, score = 100
            //   0fb745e4             | movzx               eax, word ptr [ebp - 0x1c]
            //   50                   | push                eax
            //   8d8518fdffff         | lea                 eax, [ebp - 0x2e8]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_6 = { 50 e8???????? 8d85f0fdffff 50 e8???????? 8bf0 83c40c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c40c               | add                 esp, 0xc

        $sequence_7 = { 7ce0 5f 5b c9 c3 8b542404 }
            // n = 6, score = 100
            //   7ce0                 | jl                  0xffffffe2
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8b542404             | mov                 edx, dword ptr [esp + 4]

        $sequence_8 = { e8???????? 8d85fcfdffff 50 e8???????? 8d85fcfdffff 53 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   53                   | push                ebx

        $sequence_9 = { 50 8d8518ffffff 6880000000 50 53 ff15???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d8518ffffff         | lea                 eax, [ebp - 0xe8]
            //   6880000000           | push                0x80
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 114688
}