rule win_flawedgrace_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.flawedgrace."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flawedgrace"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c685a4cdffff2c c685a5cdffff00 c685a6cdffff00 c685a7cdffff48 c685a8cdffffff c685a9cdffffce c685aacdffff0f }
            // n = 7, score = 200
            //   c685a4cdffff2c       | mov                 byte ptr [ebp - 0x325c], 0x2c
            //   c685a5cdffff00       | mov                 byte ptr [ebp - 0x325b], 0
            //   c685a6cdffff00       | mov                 byte ptr [ebp - 0x325a], 0
            //   c685a7cdffff48       | mov                 byte ptr [ebp - 0x3259], 0x48
            //   c685a8cdffffff       | mov                 byte ptr [ebp - 0x3258], 0xff
            //   c685a9cdffffce       | mov                 byte ptr [ebp - 0x3257], 0xce
            //   c685aacdffff0f       | mov                 byte ptr [ebp - 0x3256], 0xf

        $sequence_1 = { 83e03f 6bd030 895de4 8b049db8d34600 8945d4 8955e8 8a5c1029 }
            // n = 7, score = 200
            //   83e03f               | and                 eax, 0x3f
            //   6bd030               | imul                edx, eax, 0x30
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   8b049db8d34600       | mov                 eax, dword ptr [ebx*4 + 0x46d3b8]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   8a5c1029             | mov                 bl, byte ptr [eax + edx + 0x29]

        $sequence_2 = { 56 57 8bf9 c745f800000000 8bf2 8975fc 85ff }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   8bf2                 | mov                 esi, edx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   85ff                 | test                edi, edi

        $sequence_3 = { c685dbc3ffff00 c685dcc3ffff00 c685ddc3ffff00 c685dec3ffff00 c685dfc3ffff00 c685e0c3ffff00 c685e1c3ffff00 }
            // n = 7, score = 200
            //   c685dbc3ffff00       | mov                 byte ptr [ebp - 0x3c25], 0
            //   c685dcc3ffff00       | mov                 byte ptr [ebp - 0x3c24], 0
            //   c685ddc3ffff00       | mov                 byte ptr [ebp - 0x3c23], 0
            //   c685dec3ffff00       | mov                 byte ptr [ebp - 0x3c22], 0
            //   c685dfc3ffff00       | mov                 byte ptr [ebp - 0x3c21], 0
            //   c685e0c3ffff00       | mov                 byte ptr [ebp - 0x3c20], 0
            //   c685e1c3ffff00       | mov                 byte ptr [ebp - 0x3c1f], 0

        $sequence_4 = { c6858ad9ffff00 c6858bd9ffff00 c6858cd9ffff00 c6858dd9ffff00 c6858ed9ffff00 c6858fd9ffff00 c68590d9ffff00 }
            // n = 7, score = 200
            //   c6858ad9ffff00       | mov                 byte ptr [ebp - 0x2676], 0
            //   c6858bd9ffff00       | mov                 byte ptr [ebp - 0x2675], 0
            //   c6858cd9ffff00       | mov                 byte ptr [ebp - 0x2674], 0
            //   c6858dd9ffff00       | mov                 byte ptr [ebp - 0x2673], 0
            //   c6858ed9ffff00       | mov                 byte ptr [ebp - 0x2672], 0
            //   c6858fd9ffff00       | mov                 byte ptr [ebp - 0x2671], 0
            //   c68590d9ffff00       | mov                 byte ptr [ebp - 0x2670], 0

        $sequence_5 = { c7410800000000 c74110ffffffff c74114ffffffff c7411c0c000000 c701???????? c741380f000000 c7413400000000 }
            // n = 7, score = 200
            //   c7410800000000       | mov                 dword ptr [ecx + 8], 0
            //   c74110ffffffff       | mov                 dword ptr [ecx + 0x10], 0xffffffff
            //   c74114ffffffff       | mov                 dword ptr [ecx + 0x14], 0xffffffff
            //   c7411c0c000000       | mov                 dword ptr [ecx + 0x1c], 0xc
            //   c701????????         |                     
            //   c741380f000000       | mov                 dword ptr [ecx + 0x38], 0xf
            //   c7413400000000       | mov                 dword ptr [ecx + 0x34], 0

        $sequence_6 = { 75f9 2bf1 b001 5f 8933 5e 5b }
            // n = 7, score = 200
            //   75f9                 | jne                 0xfffffffb
            //   2bf1                 | sub                 esi, ecx
            //   b001                 | mov                 al, 1
            //   5f                   | pop                 edi
            //   8933                 | mov                 dword ptr [ebx], esi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_7 = { c68580d2ffff10 c68581d2ffff48 c68582d2ffff83 c68583d2ffffec c68584d2ffff20 c68585d2ffff4c }
            // n = 6, score = 200
            //   c68580d2ffff10       | mov                 byte ptr [ebp - 0x2d80], 0x10
            //   c68581d2ffff48       | mov                 byte ptr [ebp - 0x2d7f], 0x48
            //   c68582d2ffff83       | mov                 byte ptr [ebp - 0x2d7e], 0x83
            //   c68583d2ffffec       | mov                 byte ptr [ebp - 0x2d7d], 0xec
            //   c68584d2ffff20       | mov                 byte ptr [ebp - 0x2d7c], 0x20
            //   c68585d2ffff4c       | mov                 byte ptr [ebp - 0x2d7b], 0x4c

        $sequence_8 = { c744241800000000 50 ff7508 0f57c0 c744243400000000 8bf1 0f11442424 }
            // n = 7, score = 200
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   0f57c0               | xorps               xmm0, xmm0
            //   c744243400000000     | mov                 dword ptr [esp + 0x34], 0
            //   8bf1                 | mov                 esi, ecx
            //   0f11442424           | movups              xmmword ptr [esp + 0x24], xmm0

        $sequence_9 = { 0f84f8000000 8d442450 50 68???????? 8d842460010000 6804010000 50 }
            // n = 7, score = 200
            //   0f84f8000000         | je                  0xfe
            //   8d442450             | lea                 eax, [esp + 0x50]
            //   50                   | push                eax
            //   68????????           |                     
            //   8d842460010000       | lea                 eax, [esp + 0x160]
            //   6804010000           | push                0x104
            //   50                   | push                eax

    condition:
        7 of them and filesize < 966656
}