rule win_flowershop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.flowershop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flowershop"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff15???????? 85c0 59 0f8694000000 8d4604 50 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   0f8694000000         | jbe                 0x9a
            //   8d4604               | lea                 eax, [esi + 4]
            //   50                   | push                eax

        $sequence_1 = { ff15???????? 8bf8 3bfb 7472 0fb705???????? 03c5 56 }
            // n = 7, score = 500
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   3bfb                 | cmp                 edi, ebx
            //   7472                 | je                  0x74
            //   0fb705????????       |                     
            //   03c5                 | add                 eax, ebp
            //   56                   | push                esi

        $sequence_2 = { 85ff 7419 57 6a00 ff15???????? 50 ff15???????? }
            // n = 7, score = 500
            //   85ff                 | test                edi, edi
            //   7419                 | je                  0x1b
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { 3bde 7479 57 8b3d???????? 56 56 56 }
            // n = 7, score = 500
            //   3bde                 | cmp                 ebx, esi
            //   7479                 | je                  0x7b
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   56                   | push                esi
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_4 = { eb3d 8b4604 50 6a00 8b4804 894e04 ffd5 }
            // n = 7, score = 500
            //   eb3d                 | jmp                 0x3f
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   894e04               | mov                 dword ptr [esi + 4], ecx
            //   ffd5                 | call                ebp

        $sequence_5 = { 6a01 8906 8b4508 8930 58 5f 5e }
            // n = 7, score = 500
            //   6a01                 | push                1
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8930                 | mov                 dword ptr [eax], esi
            //   58                   | pop                 eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 57 e8???????? 59 85c0 59 746f 57 }
            // n = 7, score = 500
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   746f                 | je                  0x71
            //   57                   | push                edi

        $sequence_7 = { 8bf0 59 85f6 59 7455 80650b00 }
            // n = 6, score = 500
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   85f6                 | test                esi, esi
            //   59                   | pop                 ecx
            //   7455                 | je                  0x57
            //   80650b00             | and                 byte ptr [ebp + 0xb], 0

        $sequence_8 = { 817dfc03010000 7507 6a04 e9???????? a1???????? 85c0 7536 }
            // n = 7, score = 500
            //   817dfc03010000       | cmp                 dword ptr [ebp - 4], 0x103
            //   7507                 | jne                 9
            //   6a04                 | push                4
            //   e9????????           |                     
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7536                 | jne                 0x38

        $sequence_9 = { 75ea ff749e04 43 ff7510 ff550c 59 85c0 }
            // n = 7, score = 500
            //   75ea                 | jne                 0xffffffec
            //   ff749e04             | push                dword ptr [esi + ebx*4 + 4]
            //   43                   | inc                 ebx
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff550c               | call                dword ptr [ebp + 0xc]
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 829440
}