rule win_flying_dutchman_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.flying_dutchman."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flying_dutchman"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f911 770e 6a0d 58 5d c3 8b04cd94b00110 }
            // n = 7, score = 100
            //   83f911               | cmp                 ecx, 0x11
            //   770e                 | ja                  0x10
            //   6a0d                 | push                0xd
            //   58                   | pop                 eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b04cd94b00110       | mov                 eax, dword ptr [ecx*8 + 0x1001b094]

        $sequence_1 = { ffb564deffff ff15???????? 85c0 7459 8b8568deffff 3bc3 744f }
            // n = 7, score = 100
            //   ffb564deffff         | push                dword ptr [ebp - 0x219c]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7459                 | je                  0x5b
            //   8b8568deffff         | mov                 eax, dword ptr [ebp - 0x2198]
            //   3bc3                 | cmp                 eax, ebx
            //   744f                 | je                  0x51

        $sequence_2 = { 48 83c8fc 40 83f801 0f85d3000000 c747140f000000 }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   83c8fc               | or                  eax, 0xfffffffc
            //   40                   | inc                 eax
            //   83f801               | cmp                 eax, 1
            //   0f85d3000000         | jne                 0xd9
            //   c747140f000000       | mov                 dword ptr [edi + 0x14], 0xf

        $sequence_3 = { 8bec 81ecc8000000 a1???????? 33c5 8945fc 8d8538ffffff }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81ecc8000000         | sub                 esp, 0xc8
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d8538ffffff         | lea                 eax, [ebp - 0xc8]

        $sequence_4 = { 83c8ff eb03 0345ec 8b4dfc 33cd e8???????? c9 }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb03                 | jmp                 5
            //   0345ec               | add                 eax, dword ptr [ebp - 0x14]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   c9                   | leave               

        $sequence_5 = { 8d42e0 3c58 770f 0fbec2 0fbe80486e0110 }
            // n = 5, score = 100
            //   8d42e0               | lea                 eax, [edx - 0x20]
            //   3c58                 | cmp                 al, 0x58
            //   770f                 | ja                  0x11
            //   0fbec2               | movsx               eax, dl
            //   0fbe80486e0110       | movsx               eax, byte ptr [eax + 0x10016e48]

        $sequence_6 = { e8???????? c9 c20800 55 8bec 81ec38040000 a1???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec38040000         | sub                 esp, 0x438
            //   a1????????           |                     

        $sequence_7 = { 57 8985e4fdffff 8935???????? e8???????? 8b35???????? 33ff }
            // n = 6, score = 100
            //   57                   | push                edi
            //   8985e4fdffff         | mov                 dword ptr [ebp - 0x21c], eax
            //   8935????????         |                     
            //   e8????????           |                     
            //   8b35????????         |                     
            //   33ff                 | xor                 edi, edi

        $sequence_8 = { 56 8b7508 57 bbc8000000 53 6a00 bf???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   bbc8000000           | mov                 ebx, 0xc8
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   bf????????           |                     

        $sequence_9 = { 8d442410 89742408 8d4802 668b10 83c002 6685d2 75f5 }
            // n = 7, score = 100
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   89742408             | mov                 dword ptr [esp + 8], esi
            //   8d4802               | lea                 ecx, [eax + 2]
            //   668b10               | mov                 dx, word ptr [eax]
            //   83c002               | add                 eax, 2
            //   6685d2               | test                dx, dx
            //   75f5                 | jne                 0xfffffff7

    condition:
        7 of them and filesize < 276480
}