rule win_formbook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.formbook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.formbook"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 8bec 8b4508 8b480c 56 6a05 51 }
            // n = 7, score = 2200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]
            //   56                   | push                esi
            //   6a05                 | push                5
            //   51                   | push                ecx

        $sequence_1 = { c3 6a01 8d8d00fcffff 6a0a 51 e8???????? }
            // n = 6, score = 2200
            //   c3                   | ret                 
            //   6a01                 | push                1
            //   8d8d00fcffff         | lea                 ecx, [ebp - 0x400]
            //   6a0a                 | push                0xa
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_2 = { 8db4089979825a 8b4df8 8b45fc c1ca02 8bd9 8955fc 8975f8 }
            // n = 7, score = 2200
            //   8db4089979825a       | lea                 esi, [eax + ecx + 0x5a827999]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c1ca02               | ror                 edx, 2
            //   8bd9                 | mov                 ebx, ecx
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8975f8               | mov                 dword ptr [ebp - 8], esi

        $sequence_3 = { 8d8d4cfdffff 51 52 56 e8???????? 83c424 85c0 }
            // n = 7, score = 2200
            //   8d8d4cfdffff         | lea                 ecx, [ebp - 0x2b4]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   85c0                 | test                eax, eax

        $sequence_4 = { c785dcfeffff74005600 c785e0feffff65007200 c785e4feffff73006900 c785e8feffff6f006e00 }
            // n = 4, score = 2200
            //   c785dcfeffff74005600     | mov    dword ptr [ebp - 0x124], 0x560074
            //   c785e0feffff65007200     | mov    dword ptr [ebp - 0x120], 0x720065
            //   c785e4feffff73006900     | mov    dword ptr [ebp - 0x11c], 0x690073
            //   c785e8feffff6f006e00     | mov    dword ptr [ebp - 0x118], 0x6e006f

        $sequence_5 = { 0faf4ef8 83c6ec 83c002 0faf4608 83c014 3bc1 }
            // n = 6, score = 2200
            //   0faf4ef8             | imul                ecx, dword ptr [esi - 8]
            //   83c6ec               | add                 esi, -0x14
            //   83c002               | add                 eax, 2
            //   0faf4608             | imul                eax, dword ptr [esi + 8]
            //   83c014               | add                 eax, 0x14
            //   3bc1                 | cmp                 eax, ecx

        $sequence_6 = { 8b4510 8955d0 2b4134 83c408 8945cc 8b89a0000000 03cb }
            // n = 7, score = 2200
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   2b4134               | sub                 eax, dword ptr [ecx + 0x34]
            //   83c408               | add                 esp, 8
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   8b89a0000000         | mov                 ecx, dword ptr [ecx + 0xa0]
            //   03cb                 | add                 ecx, ebx

        $sequence_7 = { 33c0 81ff00000040 0f94c0 5e 5f 5b 8be5 }
            // n = 7, score = 2200
            //   33c0                 | xor                 eax, eax
            //   81ff00000040         | cmp                 edi, 0x40000000
            //   0f94c0               | sete                al
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_8 = { 898579ffffff 89857dffffff 894581 894585 894589 6689458d 88458f }
            // n = 7, score = 2200
            //   898579ffffff         | mov                 dword ptr [ebp - 0x87], eax
            //   89857dffffff         | mov                 dword ptr [ebp - 0x83], eax
            //   894581               | mov                 dword ptr [ebp - 0x7f], eax
            //   894585               | mov                 dword ptr [ebp - 0x7b], eax
            //   894589               | mov                 dword ptr [ebp - 0x77], eax
            //   6689458d             | mov                 word ptr [ebp - 0x73], ax
            //   88458f               | mov                 byte ptr [ebp - 0x71], al

        $sequence_9 = { 8b07 83c414 0345f8 5f 5e 5b }
            // n = 6, score = 2200
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   83c414               | add                 esp, 0x14
            //   0345f8               | add                 eax, dword ptr [ebp - 8]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

    condition:
        7 of them and filesize < 371712
}