rule win_fudmodule_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fudmodule."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fudmodule"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3446 4839eb f9 f5 }
            // n = 4, score = 100
            //   3446                 | mov                 dword ptr [ebp + 0x27], eax
            //   4839eb               | xor                 eax, eax
            //   f9                   | inc                 ebp
            //   f5                   | xor                 ebp, ebp

        $sequence_1 = { c7451079737465 c745146d496e66 c745186f726d61 c7451c74696f6e c6452000 c745c04e745772 c745c469746556 }
            // n = 7, score = 100
            //   c7451079737465       | mov                 dword ptr [ebp + 0x10], 0x65747379
            //   c745146d496e66       | mov                 dword ptr [ebp + 0x14], 0x666e496d
            //   c745186f726d61       | mov                 dword ptr [ebp + 0x18], 0x616d726f
            //   c7451c74696f6e       | mov                 dword ptr [ebp + 0x1c], 0x6e6f6974
            //   c6452000             | mov                 byte ptr [ebp + 0x20], 0
            //   c745c04e745772       | mov                 dword ptr [ebp - 0x40], 0x7257744e
            //   c745c469746556       | mov                 dword ptr [ebp - 0x3c], 0x56657469

        $sequence_2 = { 4585ed 0f8416010000 488d3cb0 ff15???????? 488d542448 488bc8 488d442460 }
            // n = 7, score = 100
            //   4585ed               | inc                 ecx
            //   0f8416010000         | lea                 ebx, [ebp + 8]
            //   488d3cb0             | mov                 edi, 0x2580
            //   ff15????????         |                     
            //   488d542448           | nop                 word ptr [eax + eax]
            //   488bc8               | dec                 eax
            //   488d442460           | lea                 ecx, [esp + 0x60]

        $sequence_3 = { eb20 4c8d25c0e00000 488b0d???????? bf01000000 897c2460 ff15???????? 4c8be8 }
            // n = 7, score = 100
            //   eb20                 | jmp                 0x22
            //   4c8d25c0e00000       | dec                 esp
            //   488b0d????????       |                     
            //   bf01000000           | lea                 esp, [0xe0c0]
            //   897c2460             | mov                 edi, 1
            //   ff15????????         |                     
            //   4c8be8               | mov                 dword ptr [esp + 0x60], edi

        $sequence_4 = { c745ae6e006500 66897db2 c745b453007900 c745b873007400 }
            // n = 4, score = 100
            //   c745ae6e006500       | mov                 dword ptr [ebp - 0x52], 0x65006e
            //   66897db2             | mov                 word ptr [ebp - 0x4e], di
            //   c745b453007900       | mov                 dword ptr [ebp - 0x4c], 0x790053
            //   c745b873007400       | mov                 dword ptr [ebp - 0x48], 0x740073

        $sequence_5 = { 488d3ca51c3489c2 0f8f7cf20100 660fbdfe 4801e3 66c1d707 66f7c74b20 }
            // n = 6, score = 100
            //   488d3ca51c3489c2     | mov                 ecx, eax
            //   0f8f7cf20100         | dec                 eax
            //   660fbdfe             | lea                 eax, [esp + 0x60]
            //   4801e3               | dec                 eax
            //   66c1d707             | xor                 eax, esp
            //   66f7c74b20           | dec                 eax

        $sequence_6 = { 29d2 c0c804 89d0 24a6 4883c701 }
            // n = 5, score = 100
            //   29d2                 | stc                 
            //   c0c804               | cmc                 
            //   89d0                 | ja                  0x23b89
            //   24a6                 | bt                  ebp, edx
            //   4883c701             | stc                 

        $sequence_7 = { 488b05???????? 4833c4 48894527 33c0 4533ed 4c8bf1 458d4504 }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   4833c4               | xor                 edx, edx
            //   48894527             | inc                 ecx
            //   33c0                 | mov                 eax, 0x200
            //   4533ed               | inc                 ebp
            //   4c8bf1               | test                ebp, ebp
            //   458d4504             | je                  0x11c

        $sequence_8 = { 0f87833b0200 0fa3d5 f9 f5 69d20a000000 }
            // n = 5, score = 100
            //   0f87833b0200         | dec                 esp
            //   0fa3d5               | mov                 esi, ecx
            //   f9                   | inc                 ebp
            //   f5                   | lea                 eax, [ebp + 4]
            //   69d20a000000         | inc                 sp

        $sequence_9 = { 660fa3e0 29d9 6629ce 660fbcf6 }
            // n = 4, score = 100
            //   660fa3e0             | test                di, 0x204b
            //   29d9                 | xor                 al, 0x46
            //   6629ce               | dec                 eax
            //   660fbcf6             | cmp                 ebx, ebp

        $sequence_10 = { 488d442438 4d8bc4 4889442420 41ff96d00d0000 ba4d5a0000 663955a0 }
            // n = 6, score = 100
            //   488d442438           | dec                 esp
            //   4d8bc4               | mov                 ebp, eax
            //   4889442420           | dec                 eax
            //   41ff96d00d0000       | lea                 eax, [esp + 0x38]
            //   ba4d5a0000           | dec                 ebp
            //   663955a0             | mov                 eax, esp

        $sequence_11 = { c744246c69006c00 c744247065005300 66898552010000 c744247673007400 c744247a65006d00 }
            // n = 5, score = 100
            //   c744246c69006c00     | mov                 dword ptr [esp + 0x6c], 0x6c0069
            //   c744247065005300     | mov                 dword ptr [esp + 0x70], 0x530065
            //   66898552010000       | mov                 word ptr [ebp + 0x152], ax
            //   c744247673007400     | mov                 dword ptr [esp + 0x76], 0x740073
            //   c744247a65006d00     | mov                 dword ptr [esp + 0x7a], 0x6d0065

        $sequence_12 = { 38e9 30c0 f9 f2ae 0f89bb620100 }
            // n = 5, score = 100
            //   38e9                 | mov                 dword ptr [ebp - 0x74], ebp
            //   30c0                 | mov                 dword ptr [ebp + 0x140], 0x6b005c
            //   f9                   | mov                 dword ptr [ebp + 0x144], 0x720065
            //   f2ae                 | mov                 dword ptr [ebp + 0x148], 0x65006e
            //   0f89bb620100         | mov                 dword ptr [ebp + 0x14c], 0x33006c

        $sequence_13 = { 418d5d08 bf80250000 660f1f840000000000 488d4c2460 33d2 41b800020000 }
            // n = 6, score = 100
            //   418d5d08             | dec                 eax
            //   bf80250000           | mov                 dword ptr [esp + 0x20], eax
            //   660f1f840000000000     | inc    ecx
            //   488d4c2460           | call                dword ptr [esi + 0xdd0]
            //   33d2                 | mov                 edx, 0x5a4d
            //   41b800020000         | cmp                 word ptr [ebp - 0x60], dx

        $sequence_14 = { fec8 f6c65a fec0 b02e 80fec3 }
            // n = 5, score = 100
            //   fec8                 | cmc                 
            //   f6c65a               | imul                edx, edx, 0xa
            //   fec0                 | cmp                 cl, ch
            //   b02e                 | xor                 al, al
            //   80fec3               | stc                 

        $sequence_15 = { 4829fb 66ffc7 d2f8 66ffcf f8 4801e3 660fadd7 }
            // n = 7, score = 100
            //   4829fb               | dec                 eax
            //   66ffc7               | lea                 edi, [0xc289341c]
            //   d2f8                 | jg                  0x1f282
            //   66ffcf               | bsr                 di, si
            //   f8                   | dec                 eax
            //   4801e3               | add                 ebx, esp
            //   660fadd7             | rcl                 di, 7

    condition:
        7 of them and filesize < 795648
}