rule win_gacrux_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gacrux."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gacrux"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7410 44 8bc2 48 8bc6 33d2 49 }
            // n = 7, score = 300
            //   7410                 | je                  0x12
            //   44                   | inc                 esp
            //   8bc2                 | mov                 eax, edx
            //   48                   | dec                 eax
            //   8bc6                 | mov                 eax, esi
            //   33d2                 | xor                 edx, edx
            //   49                   | dec                 ecx

        $sequence_1 = { e8???????? 48 8bcf e8???????? 8b442450 48 8b5c2458 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]
            //   48                   | dec                 eax
            //   8b5c2458             | mov                 ebx, dword ptr [esp + 0x58]

        $sequence_2 = { 4c 23e9 48 23c1 }
            // n = 4, score = 300
            //   4c                   | dec                 esp
            //   23e9                 | and                 ebp, ecx
            //   48                   | dec                 eax
            //   23c1                 | and                 eax, ecx

        $sequence_3 = { 8d4c2438 45 33c0 33d2 }
            // n = 4, score = 300
            //   8d4c2438             | lea                 ecx, [esp + 0x38]
            //   45                   | inc                 ebp
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx

        $sequence_4 = { 85c9 0f857bffffff 898d28010000 48 8d8528010000 }
            // n = 5, score = 300
            //   85c9                 | test                ecx, ecx
            //   0f857bffffff         | jne                 0xffffff81
            //   898d28010000         | mov                 dword ptr [ebp + 0x128], ecx
            //   48                   | dec                 eax
            //   8d8528010000         | lea                 eax, [ebp + 0x128]

        $sequence_5 = { 33c9 4d 8d5202 41 8bc9 }
            // n = 5, score = 300
            //   33c9                 | xor                 ecx, ecx
            //   4d                   | dec                 ebp
            //   8d5202               | lea                 edx, [edx + 2]
            //   41                   | inc                 ecx
            //   8bc9                 | mov                 ecx, ecx

        $sequence_6 = { 48 83ec40 41 8be8 4c 8bf2 41 }
            // n = 7, score = 300
            //   48                   | dec                 eax
            //   83ec40               | sub                 esp, 0x40
            //   41                   | inc                 ecx
            //   8be8                 | mov                 ebp, eax
            //   4c                   | dec                 esp
            //   8bf2                 | mov                 esi, edx
            //   41                   | inc                 ecx

        $sequence_7 = { 8b0f e8???????? 48 85c0 751b }
            // n = 5, score = 300
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   751b                 | jne                 0x1d

        $sequence_8 = { b8e9bfac86 48 6bd938 e8???????? 4c 8bcb 4c }
            // n = 7, score = 300
            //   b8e9bfac86           | mov                 eax, 0x86acbfe9
            //   48                   | dec                 eax
            //   6bd938               | imul                ebx, ecx, 0x38
            //   e8????????           |                     
            //   4c                   | dec                 esp
            //   8bcb                 | mov                 ecx, ebx
            //   4c                   | dec                 esp

        $sequence_9 = { 41 8bd4 e8???????? 48 8d4c2430 45 }
            // n = 6, score = 300
            //   41                   | inc                 ecx
            //   8bd4                 | mov                 edx, esp
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   45                   | inc                 ebp

    condition:
        7 of them and filesize < 122880
}