rule win_gameover_p2p_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gameover_p2p."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gameover_p2p"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 84c0 745f 53 bb00080000 3bf3 57 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   745f                 | je                  0x61
            //   53                   | push                ebx
            //   bb00080000           | mov                 ebx, 0x800
            //   3bf3                 | cmp                 esi, ebx
            //   57                   | push                edi

        $sequence_1 = { 897c2424 896c2414 85c0 740f 8d542414 8bc8 }
            // n = 6, score = 100
            //   897c2424             | mov                 dword ptr [esp + 0x24], edi
            //   896c2414             | mov                 dword ptr [esp + 0x14], ebp
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   8bc8                 | mov                 ecx, eax

        $sequence_2 = { ff15???????? 8b4e0c 85c9 740f 8b5608 e8???????? 8b7608 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]
            //   85c9                 | test                ecx, ecx
            //   740f                 | je                  0x11
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   e8????????           |                     
            //   8b7608               | mov                 esi, dword ptr [esi + 8]

        $sequence_3 = { 834c2418ff 6880000000 6a01 53 53 8d442430 }
            // n = 6, score = 100
            //   834c2418ff           | or                  dword ptr [esp + 0x18], 0xffffffff
            //   6880000000           | push                0x80
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8d442430             | lea                 eax, [esp + 0x30]

        $sequence_4 = { 8d7e18 f60601 0f854efeffff 51 8d4c2430 e8???????? 8b4e50 }
            // n = 7, score = 100
            //   8d7e18               | lea                 edi, [esi + 0x18]
            //   f60601               | test                byte ptr [esi], 1
            //   0f854efeffff         | jne                 0xfffffe54
            //   51                   | push                ecx
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     
            //   8b4e50               | mov                 ecx, dword ptr [esi + 0x50]

        $sequence_5 = { 7415 ff770c 8d442418 51 }
            // n = 4, score = 100
            //   7415                 | je                  0x17
            //   ff770c               | push                dword ptr [edi + 0xc]
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   51                   | push                ecx

        $sequence_6 = { 7409 8bd0 33c9 e8???????? 32c0 5e c9 }
            // n = 7, score = 100
            //   7409                 | je                  0xb
            //   8bd0                 | mov                 edx, eax
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   32c0                 | xor                 al, al
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_7 = { ffd5 83c40c f6c308 7408 668b4734 66894634 33c0 }
            // n = 7, score = 100
            //   ffd5                 | call                ebp
            //   83c40c               | add                 esp, 0xc
            //   f6c308               | test                bl, 8
            //   7408                 | je                  0xa
            //   668b4734             | mov                 ax, word ptr [edi + 0x34]
            //   66894634             | mov                 word ptr [esi + 0x34], ax
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 5e 5b c9 c20800 85db 7427 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   85db                 | test                ebx, ebx
            //   7427                 | je                  0x29

        $sequence_9 = { 0f8481000000 57 ff75fc bf04010000 68???????? 53 8d85f0fdffff }
            // n = 7, score = 100
            //   0f8481000000         | je                  0x87
            //   57                   | push                edi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   bf04010000           | mov                 edi, 0x104
            //   68????????           |                     
            //   53                   | push                ebx
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]

    condition:
        7 of them and filesize < 598016
}