rule win_gaudox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gaudox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gaudox"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89450c 8b4dfc 8d4508 50 8b450c 8b11 8d04b0 }
            // n = 7, score = 200
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8d04b0               | lea                 eax, [eax + esi*4]

        $sequence_1 = { 8b4dfc 890e 5e 8be5 5d c3 8b01 }
            // n = 7, score = 200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   890e                 | mov                 dword ptr [esi], ecx
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b01                 | mov                 eax, dword ptr [ecx]

        $sequence_2 = { b9???????? 57 ffb0b4010000 8d45e0 50 e8???????? }
            // n = 6, score = 200
            //   b9????????           |                     
            //   57                   | push                edi
            //   ffb0b4010000         | push                dword ptr [eax + 0x1b4]
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 50 6a00 6a00 6a02 56 6a0a 6a00 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   56                   | push                esi
            //   6a0a                 | push                0xa
            //   6a00                 | push                0

        $sequence_4 = { 81f9361d0c5b 741b 81f9640eb076 7413 81f9738429e3 740b }
            // n = 6, score = 200
            //   81f9361d0c5b         | cmp                 ecx, 0x5b0c1d36
            //   741b                 | je                  0x1d
            //   81f9640eb076         | cmp                 ecx, 0x76b00e64
            //   7413                 | je                  0x15
            //   81f9738429e3         | cmp                 ecx, 0xe3298473
            //   740b                 | je                  0xd

        $sequence_5 = { 5d c20c00 b87b0000c0 5f 5e 5b 8be5 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   b87b0000c0           | mov                 eax, 0xc000007b
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_6 = { 85c0 7411 3bc6 8d8ddcfeffff 0f47c6 50 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   3bc6                 | cmp                 eax, esi
            //   8d8ddcfeffff         | lea                 ecx, [ebp - 0x124]
            //   0f47c6               | cmova               eax, esi
            //   50                   | push                eax

        $sequence_7 = { 6689442432 8d442460 89442434 a1???????? 8944244c 8d442430 }
            // n = 6, score = 200
            //   6689442432           | mov                 word ptr [esp + 0x32], ax
            //   8d442460             | lea                 eax, [esp + 0x60]
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   a1????????           |                     
            //   8944244c             | mov                 dword ptr [esp + 0x4c], eax
            //   8d442430             | lea                 eax, [esp + 0x30]

        $sequence_8 = { e8???????? ff75f0 6a02 6a03 e8???????? 33c0 5e }
            // n = 7, score = 200
            //   e8????????           |                     
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   6a02                 | push                2
            //   6a03                 | push                3
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi

        $sequence_9 = { 83fa6c 751f 83f902 7212 6639544702 750b 810e00040000 }
            // n = 7, score = 200
            //   83fa6c               | cmp                 edx, 0x6c
            //   751f                 | jne                 0x21
            //   83f902               | cmp                 ecx, 2
            //   7212                 | jb                  0x14
            //   6639544702           | cmp                 word ptr [edi + eax*2 + 2], dx
            //   750b                 | jne                 0xd
            //   810e00040000         | or                  dword ptr [esi], 0x400

    condition:
        7 of them and filesize < 155648
}