rule win_gazer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gazer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gazer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7511 e8???????? 84c0 7508 }
            // n = 5, score = 300
            //   85c0                 | push                dword ptr [ebp + 0xc]
            //   7511                 | push                eax
            //   e8????????           |                     
            //   84c0                 | push                0x243
            //   7508                 | push                0x100373a0

        $sequence_1 = { ff15???????? 85c0 7511 e8???????? 84c0 7508 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   85c0                 | jne                 0x272
            //   7511                 | mov                 esi, dword ptr [esp + 0x1c]
            //   e8????????           |                     
            //   84c0                 | push                dword ptr [esi]
            //   7508                 | push                0x159

        $sequence_2 = { ff15???????? 85c0 7511 e8???????? 84c0 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   85c0                 | lea                 ecx, [ebp - 0x28]
            //   7511                 | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   84c0                 | lea                 ebx, [ebp - 0x28]

        $sequence_3 = { ff15???????? 85c0 7511 e8???????? 84c0 7508 83c8ff }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   85c0                 | push                0x3bb
            //   7511                 | mov                 ebx, 0x100379a0
            //   e8????????           |                     
            //   84c0                 | mov                 ebx, edi
            //   7508                 | mov                 esi, dword ptr [esi]
            //   83c8ff               | cmp                 esi, dword ptr [esp + 0x44]

        $sequence_4 = { 7511 e8???????? 84c0 7508 83c8ff }
            // n = 5, score = 300
            //   7511                 | lea                 eax, [esp + 0x40]
            //   e8????????           |                     
            //   84c0                 | dec                 eax
            //   7508                 | lea                 edx, [ebp - 0x58]
            //   83c8ff               | dec                 ebp

        $sequence_5 = { 85c0 7511 e8???????? 84c0 }
            // n = 4, score = 300
            //   85c0                 | push                0x10037b58
            //   7511                 | push                0x58c
            //   e8????????           |                     
            //   84c0                 | push                ebx

        $sequence_6 = { 7511 e8???????? 84c0 7508 83c8ff e9???????? }
            // n = 6, score = 300
            //   7511                 | cmp                 byte ptr [ecx + 0x14], dh
            //   e8????????           |                     
            //   84c0                 | je                  0x1ffe
            //   7508                 | or                  ebp, 0xffffffff
            //   83c8ff               | inc                 ecx
            //   e9????????           |                     

        $sequence_7 = { 85c0 7511 e8???????? 84c0 7508 83c8ff }
            // n = 6, score = 300
            //   85c0                 | push                edx
            //   7511                 | mov                 dword ptr [esp + 0x7c], 7
            //   e8????????           |                     
            //   84c0                 | pop                 eax
            //   7508                 | mov                 word ptr [esp + 0x58], ax
            //   83c8ff               | lea                 eax, [esp + 0x54]

        $sequence_8 = { 85c0 7511 e8???????? 84c0 7508 83c8ff e9???????? }
            // n = 7, score = 300
            //   85c0                 | mov                 al, 1
            //   7511                 | pop                 esi
            //   e8????????           |                     
            //   84c0                 | leave               
            //   7508                 | ret                 4
            //   83c8ff               | pop                 ecx
            //   e9????????           |                     

        $sequence_9 = { 0fb6420e 894c2408 0fb64a0f c1e108 0bc8 0fb6420d c1e108 }
            // n = 7, score = 200
            //   0fb6420e             | mov                 edx, dword ptr [edi + 0x50]
            //   894c2408             | dec                 esp
            //   0fb64a0f             | lea                 eax, [edi + 0x128]
            //   c1e108               | dec                 eax
            //   0bc8                 | mov                 ecx, edi
            //   0fb6420d             | test                al, al
            //   c1e108               | je                  0x554

    condition:
        7 of them and filesize < 950272
}