rule win_gearshift_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gearshift."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gearshift"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41bb00020000 4c8d0d11a2ffff 458a20 4584e4 0f8547f9ffff 44385598 740b }
            // n = 7, score = 200
            //   41bb00020000         | lea                 ebp, [esp - 0x178]
            //   4c8d0d11a2ffff       | dec                 eax
            //   458a20               | sub                 esp, 0x278
            //   4584e4               | xor                 eax, eax
            //   0f8547f9ffff         | inc                 ebp
            //   44385598             | mov                 edi, eax
            //   740b                 | inc                 ecx

        $sequence_1 = { 664189844888b40300 ffc2 ebe2 8bd7 89542420 }
            // n = 5, score = 200
            //   664189844888b40300     | mov    edi, edx
            //   ffc2                 | dec                 eax
            //   ebe2                 | mov                 ebx, ecx
            //   8bd7                 | dec                 eax
            //   89542420             | lea                 eax, [0x8c35]

        $sequence_2 = { 85c0 0f8565010000 488d4c2424 33d2 }
            // n = 4, score = 200
            //   85c0                 | push                0x10002a9c
            //   0f8565010000         | push                dword ptr fs:[0]
            //   488d4c2424           | push                ecx
            //   33d2                 | push                ebx

        $sequence_3 = { 85c0 750d 8b442428 ffc6 4883c304 }
            // n = 5, score = 200
            //   85c0                 | inc                 ecx
            //   750d                 | mov                 eax, 0x258
            //   8b442428             | dec                 eax
            //   ffc6                 | lea                 ecx, [ebp + 0x321]
            //   4883c304             | dec                 eax

        $sequence_4 = { 488bcb 48894550 ff15???????? 48894558 48397548 }
            // n = 5, score = 200
            //   488bcb               | mov                 eax, dword ptr [edx + 0x10]
            //   48894550             | dec                 eax
            //   ff15????????         |                     
            //   48894558             | mov                 dword ptr [ecx + 0x28], eax
            //   48397548             | dec                 eax

        $sequence_5 = { 498bcc e8???????? 85c0 750d }
            // n = 4, score = 200
            //   498bcc               | mov                 ebx, ecx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0x12f2

        $sequence_6 = { 41b800100000 4c896008 4c897810 4c897818 418b5550 498bcc }
            // n = 6, score = 200
            //   41b800100000         | je                  0x227
            //   4c896008             | dec                 eax
            //   4c897810             | mov                 ecx, dword ptr [ebx + 0x20]
            //   4c897818             | dec                 eax
            //   418b5550             | cmp                 edx, ecx
            //   498bcc               | je                  0x299

        $sequence_7 = { ff96b0000000 85c0 0f8408ffffff 488b4500 48ba00000000ffffffff 488b7830 0fb74814 }
            // n = 7, score = 200
            //   ff96b0000000         | add                 esp, 8
            //   85c0                 | mov                 ecx, eax
            //   0f8408ffffff         | add                 esp, 4
            //   488b4500             | test                ecx, ecx
            //   48ba00000000ffffffff     | je    0x1bb7
            //   488b7830             | mov                 eax, ebp
            //   0fb74814             | mov                 ecx, ebx

        $sequence_8 = { c6858000000000 e8???????? 4c8d442438 418bd7 }
            // n = 4, score = 200
            //   c6858000000000       | mov                 ecx, dword ptr [esp + 0x38]
            //   e8????????           |                     
            //   4c8d442438           | dec                 eax
            //   418bd7               | mov                 ebx, dword ptr [esp + 0x20]

        $sequence_9 = { 488bc8 ff15???????? 4885c0 7449 488d4df7 }
            // n = 5, score = 200
            //   488bc8               | mov                 edx, eax
            //   ff15????????         |                     
            //   4885c0               | dec                 eax
            //   7449                 | test                edx, edx
            //   488d4df7             | jne                 0xac

    condition:
        7 of them and filesize < 540672
}