rule win_geminiduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.geminiduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.geminiduke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? e8???????? 83c404 50 6801000080 ff15???????? }
            // n = 6, score = 400
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     

        $sequence_1 = { 8b7c2410 8b442414 8b4c2418 f3aa 5f 59 }
            // n = 6, score = 400
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   5f                   | pop                 edi
            //   59                   | pop                 ecx

        $sequence_2 = { 6819000200 6a00 68???????? e8???????? }
            // n = 4, score = 400
            //   6819000200           | push                0x20019
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 50 51 57 8b7c2410 }
            // n = 4, score = 400
            //   50                   | push                eax
            //   51                   | push                ecx
            //   57                   | push                edi
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]

        $sequence_4 = { 034590 03c8 894dd0 8b45f8 }
            // n = 4, score = 300
            //   034590               | add                 eax, dword ptr [ebp - 0x70]
            //   03c8                 | add                 ecx, eax
            //   894dd0               | mov                 dword ptr [ebp - 0x30], ecx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_5 = { 034584 8b8d64ffffff c1e907 8b9564ffffff c1e219 0bca }
            // n = 6, score = 300
            //   034584               | add                 eax, dword ptr [ebp - 0x7c]
            //   8b8d64ffffff         | mov                 ecx, dword ptr [ebp - 0x9c]
            //   c1e907               | shr                 ecx, 7
            //   8b9564ffffff         | mov                 edx, dword ptr [ebp - 0x9c]
            //   c1e219               | shl                 edx, 0x19
            //   0bca                 | or                  ecx, edx

        $sequence_6 = { 03459c 03c8 894ddc 8b45fc }
            // n = 4, score = 300
            //   03459c               | add                 eax, dword ptr [ebp - 0x64]
            //   03c8                 | add                 ecx, eax
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_7 = { 034590 8b8d70ffffff c1e907 8b9570ffffff }
            // n = 4, score = 300
            //   034590               | add                 eax, dword ptr [ebp - 0x70]
            //   8b8d70ffffff         | mov                 ecx, dword ptr [ebp - 0x90]
            //   c1e907               | shr                 ecx, 7
            //   8b9570ffffff         | mov                 edx, dword ptr [ebp - 0x90]

        $sequence_8 = { 8ac1 0430 8ad1 80ea0a 80fa05 7705 }
            // n = 6, score = 200
            //   8ac1                 | mov                 al, cl
            //   0430                 | add                 al, 0x30
            //   8ad1                 | mov                 dl, cl
            //   80ea0a               | sub                 dl, 0xa
            //   80fa05               | cmp                 dl, 5
            //   7705                 | ja                  7

        $sequence_9 = { 337704 33e8 8b442410 c1ee12 83e601 33ee 896f24 }
            // n = 7, score = 200
            //   337704               | xor                 esi, dword ptr [edi + 4]
            //   33e8                 | xor                 ebp, eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   c1ee12               | shr                 esi, 0x12
            //   83e601               | and                 esi, 1
            //   33ee                 | xor                 ebp, esi
            //   896f24               | mov                 dword ptr [edi + 0x24], ebp

        $sequence_10 = { 80f919 7703 b001 c3 }
            // n = 4, score = 200
            //   80f919               | cmp                 cl, 0x19
            //   7703                 | ja                  5
            //   b001                 | mov                 al, 1
            //   c3                   | ret                 

        $sequence_11 = { 668907 8bc2 5a 5b 59 }
            // n = 5, score = 200
            //   668907               | mov                 word ptr [edi], ax
            //   8bc2                 | mov                 eax, edx
            //   5a                   | pop                 edx
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx

        $sequence_12 = { 57 51 53 52 33db 8b7c2418 8b74241c }
            // n = 7, score = 200
            //   57                   | push                edi
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   52                   | push                edx
            //   33db                 | xor                 ebx, ebx
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]

        $sequence_13 = { 66894704 8bc2 c1e010 668b4602 33d2 f7f3 }
            // n = 6, score = 200
            //   66894704             | mov                 word ptr [edi + 4], ax
            //   8bc2                 | mov                 eax, edx
            //   c1e010               | shl                 eax, 0x10
            //   668b4602             | mov                 ax, word ptr [esi + 2]
            //   33d2                 | xor                 edx, edx
            //   f7f3                 | div                 ebx

    condition:
        7 of them and filesize < 327680
}