rule win_get2_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.get2."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.get2"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 52 8d8d24ffffff 895dfc e8???????? c645fc02 }
            // n = 6, score = 1000
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8d8d24ffffff         | lea                 ecx, [ebp - 0xdc]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   e8????????           |                     
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2

        $sequence_1 = { e8???????? ff7508 8d55d8 8d8d24ffffff }
            // n = 4, score = 1000
            //   e8????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   8d8d24ffffff         | lea                 ecx, [ebp - 0xdc]

        $sequence_2 = { 32c0 85d2 744e 8b898c000000 85c9 7444 8b4508 }
            // n = 7, score = 1000
            //   32c0                 | xor                 al, al
            //   85d2                 | test                edx, edx
            //   744e                 | je                  0x50
            //   8b898c000000         | mov                 ecx, dword ptr [ecx + 0x8c]
            //   85c9                 | test                ecx, ecx
            //   7444                 | je                  0x46
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_3 = { c20800 64a12c000000 8b15???????? 56 8bf1 8b1490 }
            // n = 6, score = 1000
            //   c20800               | ret                 8
            //   64a12c000000         | mov                 eax, dword ptr fs:[0x2c]
            //   8b15????????         |                     
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8b1490               | mov                 edx, dword ptr [eax + edx*4]

        $sequence_4 = { f20f110c24 ffd2 59 59 b001 }
            // n = 5, score = 1000
            //   f20f110c24           | movsd               qword ptr [esp], xmm1
            //   ffd2                 | call                edx
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   b001                 | mov                 al, 1

        $sequence_5 = { 0f849e000000 807d0c00 0f859a000000 f6c104 7430 }
            // n = 5, score = 1000
            //   0f849e000000         | je                  0xa4
            //   807d0c00             | cmp                 byte ptr [ebp + 0xc], 0
            //   0f859a000000         | jne                 0xa0
            //   f6c104               | test                cl, 4
            //   7430                 | je                  0x32

        $sequence_6 = { 74d5 8d4d84 e8???????? 8d4584 c645fc03 50 }
            // n = 6, score = 1000
            //   74d5                 | je                  0xffffffd7
            //   8d4d84               | lea                 ecx, [ebp - 0x7c]
            //   e8????????           |                     
            //   8d4584               | lea                 eax, [ebp - 0x7c]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   50                   | push                eax

        $sequence_7 = { 43 897de8 33c0 895dd4 668945d8 51 51 }
            // n = 7, score = 1000
            //   43                   | inc                 ebx
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   33c0                 | xor                 eax, eax
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   51                   | push                ecx
            //   51                   | push                ecx

        $sequence_8 = { 4e8d04f500000000 33d2 e8???????? 448b06 33d2 488b4e20 }
            // n = 6, score = 100
            //   4e8d04f500000000     | cmp                 ebp, edi
            //   33d2                 | jb                  0xffffffb9
            //   e8????????           |                     
            //   448b06               | dec                 esi
            //   33d2                 | lea                 eax, [esi*8]
            //   488b4e20             | xor                 edx, edx

        $sequence_9 = { ebcc 49ffc5 4d3bef 72b4 }
            // n = 4, score = 100
            //   ebcc                 | jmp                 0xffffffce
            //   49ffc5               | dec                 ecx
            //   4d3bef               | inc                 ebp
            //   72b4                 | dec                 ebp

        $sequence_10 = { 4103c9 443bc1 0f82f8000000 66ffc2 66413bd3 }
            // n = 5, score = 100
            //   4103c9               | mov                 ecx, 5
            //   443bc1               | dec                 esp
            //   0f82f8000000         | lea                 eax, [0x15f51]
            //   66ffc2               | dec                 eax
            //   66413bd3             | lea                 edx, [0xd9da]

        $sequence_11 = { 4c8d0d655f0100 b905000000 4c8d05515f0100 488d15dad90000 e8???????? 488bf8 }
            // n = 6, score = 100
            //   4c8d0d655f0100       | mov                 ecx, dword ptr [esi + 0x20]
            //   b905000000           | je                  0x6a
            //   4c8d05515f0100       | dec                 eax
            //   488d15dad90000       | test                edi, edi
            //   e8????????           |                     
            //   488bf8               | jle                 0x60

        $sequence_12 = { 4d8b742408 498b1c24 4533ff 493bde }
            // n = 4, score = 100
            //   4d8b742408           | dec                 ecx
            //   498b1c24             | mov                 ecx, edi
            //   4533ff               | test                al, al
            //   493bde               | inc                 ecx

        $sequence_13 = { eb13 498bd6 498bcf e8???????? 84c0 }
            // n = 5, score = 100
            //   eb13                 | dec                 eax
            //   498bd6               | mov                 eax, dword ptr [esi]
            //   498bcf               | dec                 esp
            //   e8????????           |                     
            //   84c0                 | lea                 ecx, [0x15f65]

        $sequence_14 = { 7468 4885ff 7e5b 488b06 }
            // n = 4, score = 100
            //   7468                 | inc                 esp
            //   4885ff               | mov                 eax, dword ptr [esi]
            //   7e5b                 | xor                 edx, edx
            //   488b06               | dec                 eax

        $sequence_15 = { 56 57 488d6c24a0 4881ec60010000 48c7442428feffffff }
            // n = 5, score = 100
            //   56                   | dec                 eax
            //   57                   | mov                 edi, eax
            //   488d6c24a0           | jmp                 0x15
            //   4881ec60010000       | dec                 ecx
            //   48c7442428feffffff     | mov    edx, esi

    condition:
        7 of them and filesize < 720896
}