rule win_gibberish_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gibberish."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gibberish"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8d60ffffff e8???????? c703???????? 8bc3 897b28 89732c e8???????? }
            // n = 7, score = 100
            //   8d8d60ffffff         | lea                 ecx, [ebp - 0xa0]
            //   e8????????           |                     
            //   c703????????         |                     
            //   8bc3                 | mov                 eax, ebx
            //   897b28               | mov                 dword ptr [ebx + 0x28], edi
            //   89732c               | mov                 dword ptr [ebx + 0x2c], esi
            //   e8????????           |                     

        $sequence_1 = { 33d2 f77510 895590 8945a0 83fa0a 7d09 c745a430000000 }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   f77510               | div                 dword ptr [ebp + 0x10]
            //   895590               | mov                 dword ptr [ebp - 0x70], edx
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax
            //   83fa0a               | cmp                 edx, 0xa
            //   7d09                 | jge                 0xb
            //   c745a430000000       | mov                 dword ptr [ebp - 0x5c], 0x30

        $sequence_2 = { 660f58348510ed4500 660f5625???????? f20f58f0 660f54cc f20f10d3 660f73d31f }
            // n = 6, score = 100
            //   660f58348510ed4500     | addpd    xmm6, xmmword ptr [eax*4 + 0x45ed10]
            //   660f5625????????     |                     
            //   f20f58f0             | addsd               xmm6, xmm0
            //   660f54cc             | andpd               xmm1, xmm4
            //   f20f10d3             | movsd               xmm2, xmm3
            //   660f73d31f           | psrlq               xmm3, 0x1f

        $sequence_3 = { 8b0ccdf2a94700 0fb680c8a94500 330cc5f1a94700 8bc2 c1e818 0fb680c8a94500 330cc5f4a94700 }
            // n = 7, score = 100
            //   8b0ccdf2a94700       | mov                 ecx, dword ptr [ecx*8 + 0x47a9f2]
            //   0fb680c8a94500       | movzx               eax, byte ptr [eax + 0x45a9c8]
            //   330cc5f1a94700       | xor                 ecx, dword ptr [eax*8 + 0x47a9f1]
            //   8bc2                 | mov                 eax, edx
            //   c1e818               | shr                 eax, 0x18
            //   0fb680c8a94500       | movzx               eax, byte ptr [eax + 0x45a9c8]
            //   330cc5f4a94700       | xor                 ecx, dword ptr [eax*8 + 0x47a9f4]

        $sequence_4 = { 663906 0f8542fdffff e9???????? 55 8bec 51 }
            // n = 6, score = 100
            //   663906               | cmp                 word ptr [esi], ax
            //   0f8542fdffff         | jne                 0xfffffd48
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx

        $sequence_5 = { 0f1f4000 8a07 47 84c0 75f9 8b7314 2bfa }
            // n = 7, score = 100
            //   0f1f4000             | nop                 dword ptr [eax]
            //   8a07                 | mov                 al, byte ptr [edi]
            //   47                   | inc                 edi
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   8b7314               | mov                 esi, dword ptr [ebx + 0x14]
            //   2bfa                 | sub                 edi, edx

        $sequence_6 = { 89842488000000 8bc1 c1c00a 33d0 }
            // n = 4, score = 100
            //   89842488000000       | mov                 dword ptr [esp + 0x88], eax
            //   8bc1                 | mov                 eax, ecx
            //   c1c00a               | rol                 eax, 0xa
            //   33d0                 | xor                 edx, eax

        $sequence_7 = { 56 57 f6c303 0f850f010000 a803 0f8507010000 8bfa }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   f6c303               | test                bl, 3
            //   0f850f010000         | jne                 0x115
            //   a803                 | test                al, 3
            //   0f8507010000         | jne                 0x10d
            //   8bfa                 | mov                 edi, edx

        $sequence_8 = { 334c2420 23c1 33442424 03c2 8944241c 85ed 743c }
            // n = 7, score = 100
            //   334c2420             | xor                 ecx, dword ptr [esp + 0x20]
            //   23c1                 | and                 eax, ecx
            //   33442424             | xor                 eax, dword ptr [esp + 0x24]
            //   03c2                 | add                 eax, edx
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   85ed                 | test                ebp, ebp
            //   743c                 | je                  0x3e

        $sequence_9 = { 25ff000000 83c001 25fe010000 f20f593c85e0dc4500 660f122c85e0dc4500 03c0 }
            // n = 6, score = 100
            //   25ff000000           | and                 eax, 0xff
            //   83c001               | add                 eax, 1
            //   25fe010000           | and                 eax, 0x1fe
            //   f20f593c85e0dc4500     | mulsd    xmm7, qword ptr [eax*4 + 0x45dce0]
            //   660f122c85e0dc4500     | movlpd    xmm5, qword ptr [eax*4 + 0x45dce0]
            //   03c0                 | add                 eax, eax

    condition:
        7 of them and filesize < 1068032
}