rule win_globe_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.globe_ransom"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 8b4508 8b40fc 8b55f0 8d0490 8b13 e8???????? }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b40fc               | mov                 eax, dword ptr [eax - 4]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8d0490               | lea                 eax, [eax + edx*4]
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   e8????????           |                     

        $sequence_1 = { e8???????? 85c0 0f8520010000 33c0 55 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8520010000         | jne                 0x126
            //   33c0                 | xor                 eax, eax
            //   55                   | push                ebp

        $sequence_2 = { 648920 e8???????? 33d2 55 }
            // n = 4, score = 200
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   55                   | push                ebp

        $sequence_3 = { 8bc3 8b0c24 e8???????? e9???????? 8b542420 8b5208 89542404 }
            // n = 7, score = 200
            //   8bc3                 | mov                 eax, ebx
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   8b5208               | mov                 edx, dword ptr [edx + 8]
            //   89542404             | mov                 dword ptr [esp + 4], edx

        $sequence_4 = { 830608 3b1e 77cd 8b45f8 8b4014 8b149d34634600 2355fc }
            // n = 7, score = 200
            //   830608               | add                 dword ptr [esi], 8
            //   3b1e                 | cmp                 ebx, dword ptr [esi]
            //   77cd                 | ja                  0xffffffcf
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b4014               | mov                 eax, dword ptr [eax + 0x14]
            //   8b149d34634600       | mov                 edx, dword ptr [ebx*4 + 0x466334]
            //   2355fc               | and                 edx, dword ptr [ebp - 4]

        $sequence_5 = { 80780d00 7427 33c0 55 }
            // n = 4, score = 200
            //   80780d00             | cmp                 byte ptr [eax + 0xd], 0
            //   7427                 | je                  0x29
            //   33c0                 | xor                 eax, eax
            //   55                   | push                ebp

        $sequence_6 = { a1???????? e8???????? 84c0 7439 ff75fc a1???????? ff30 }
            // n = 7, score = 200
            //   a1????????           |                     
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7439                 | je                  0x3b
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   a1????????           |                     
            //   ff30                 | push                dword ptr [eax]

        $sequence_7 = { 83e20f 8a92b4604600 33db 8ad9 88141e c1e804 49 }
            // n = 7, score = 200
            //   83e20f               | and                 edx, 0xf
            //   8a92b4604600         | mov                 dl, byte ptr [edx + 0x4660b4]
            //   33db                 | xor                 ebx, ebx
            //   8ad9                 | mov                 bl, cl
            //   88141e               | mov                 byte ptr [esi + ebx], dl
            //   c1e804               | shr                 eax, 4
            //   49                   | dec                 ecx

        $sequence_8 = { ff16 898358010000 c700???????? c74004???????? c74008???????? c7400c30f54500 c740103cf54500 }
            // n = 7, score = 200
            //   ff16                 | call                dword ptr [esi]
            //   898358010000         | mov                 dword ptr [ebx + 0x158], eax
            //   c700????????         |                     
            //   c74004????????       |                     
            //   c74008????????       |                     
            //   c7400c30f54500       | mov                 dword ptr [eax + 0xc], 0x45f530
            //   c740103cf54500       | mov                 dword ptr [eax + 0x10], 0x45f53c

        $sequence_9 = { a1???????? 8b08 ff5150 33c0 }
            // n = 4, score = 200
            //   a1????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5150               | call                dword ptr [ecx + 0x50]
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 958464
}