rule win_glooxmail_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.glooxmail."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.glooxmail"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4dd8 e8???????? 8d45a0 50 8d45d8 c745fc17000000 814d5c00020000 }
            // n = 7, score = 100
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   8d45a0               | lea                 eax, [ebp - 0x60]
            //   50                   | push                eax
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   c745fc17000000       | mov                 dword ptr [ebp - 4], 0x17
            //   814d5c00020000       | or                  dword ptr [ebp + 0x5c], 0x200

        $sequence_1 = { 3bc3 744a 68???????? 8d8c24f0010000 e8???????? 8b442418 c684246004000020 }
            // n = 7, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   744a                 | je                  0x4c
            //   68????????           |                     
            //   8d8c24f0010000       | lea                 ecx, [esp + 0x1f0]
            //   e8????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   c684246004000020     | mov                 byte ptr [esp + 0x460], 0x20

        $sequence_2 = { e8???????? c68424a000000003 68???????? 8d4c2428 895c2418 e8???????? 57 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c68424a000000003     | mov                 byte ptr [esp + 0xa0], 3
            //   68????????           |                     
            //   8d4c2428             | lea                 ecx, [esp + 0x28]
            //   895c2418             | mov                 dword ptr [esp + 0x18], ebx
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_3 = { 5e c20400 6a3c b8???????? e8???????? 8b7508 8d4604 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   6a3c                 | push                0x3c
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d4604               | lea                 eax, [esi + 4]

        $sequence_4 = { e8???????? 8b874c010000 83c40c 8d4dd4 3945e8 760a }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b874c010000         | mov                 eax, dword ptr [edi + 0x14c]
            //   83c40c               | add                 esp, 0xc
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   3945e8               | cmp                 dword ptr [ebp - 0x18], eax
            //   760a                 | jbe                 0xc

        $sequence_5 = { 8b4604 80b89417450000 7f15 56 e8???????? }
            // n = 5, score = 100
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   80b89417450000       | cmp                 byte ptr [eax + 0x451794], 0
            //   7f15                 | jg                  0x17
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_6 = { 7405 e8???????? 3974241c 746a 807f7c00 742c 83ec1c }
            // n = 7, score = 100
            //   7405                 | je                  7
            //   e8????????           |                     
            //   3974241c             | cmp                 dword ptr [esp + 0x1c], esi
            //   746a                 | je                  0x6c
            //   807f7c00             | cmp                 byte ptr [edi + 0x7c], 0
            //   742c                 | je                  0x2e
            //   83ec1c               | sub                 esp, 0x1c

        $sequence_7 = { bf???????? 57 8d8d24ffffff e8???????? 68???????? 8d8d5cffffff c745fc0b000000 }
            // n = 7, score = 100
            //   bf????????           |                     
            //   57                   | push                edi
            //   8d8d24ffffff         | lea                 ecx, [ebp - 0xdc]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d8d5cffffff         | lea                 ecx, [ebp - 0xa4]
            //   c745fc0b000000       | mov                 dword ptr [ebp - 4], 0xb

        $sequence_8 = { 8bc7 e8???????? 59 84c0 7414 8b4e04 85c9 }
            // n = 7, score = 100
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   84c0                 | test                al, al
            //   7414                 | je                  0x16
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   85c9                 | test                ecx, ecx

        $sequence_9 = { e8???????? 807def00 740f c783a000000002000000 e9???????? 68???????? 8d4da4 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   807def00             | cmp                 byte ptr [ebp - 0x11], 0
            //   740f                 | je                  0x11
            //   c783a000000002000000     | mov    dword ptr [ebx + 0xa0], 2
            //   e9????????           |                     
            //   68????????           |                     
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]

    condition:
        7 of them and filesize < 761856
}