rule win_gooseegg_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gooseegg."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gooseegg"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 4d8bb4f6b8dd0000 33d2 498bce }
            // n = 4, score = 100
            //   e9????????           |                     
            //   4d8bb4f6b8dd0000     | inc                 ecx
            //   33d2                 | mov                 byte ptr [edx + ecx + 0x3e], al
            //   498bce               | dec                 ebx

        $sequence_1 = { 33d2 498bce ff15???????? 488bd8 eb02 33db 4c8d357194ffff }
            // n = 7, score = 100
            //   33d2                 | dec                 eax
            //   498bce               | test                eax, eax
            //   ff15????????         |                     
            //   488bd8               | je                  0xd35
            //   eb02                 | dec                 esp
            //   33db                 | mov                 eax, dword ptr [esp + 0xa0]
            //   4c8d357194ffff       | dec                 eax

        $sequence_2 = { 41b806000000 488d155de50000 483950f0 740c 488b10 4885d2 7404 }
            // n = 7, score = 100
            //   41b806000000         | mov                 dword ptr [ebp - 8], eax
            //   488d155de50000       | mov                 eax, 4
            //   483950f0             | mov                 dword ptr [ebp - 0x30], eax
            //   740c                 | mov                 dword ptr [ebp - 0x2c], eax
            //   488b10               | dec                 eax
            //   4885d2               | lea                 eax, [0x13321]
            //   7404                 | dec                 eax

        $sequence_3 = { 660feb15???????? 660feb0d???????? 4c8d0d848c0000 f20f5cca }
            // n = 4, score = 100
            //   660feb15????????     |                     
            //   660feb0d????????     |                     
            //   4c8d0d848c0000       | dec                 eax
            //   f20f5cca             | lea                 ecx, [0xffff67bc]

        $sequence_4 = { c4c173590cc1 4c8d0d75790000 c5f359c1 c5fb101d???????? c5fb102d???????? c4e2f1a91d???????? c4e2f1a92d???????? }
            // n = 7, score = 100
            //   c4c173590cc1         | mov                 ebx, edx
            //   4c8d0d75790000       | dec                 eax
            //   c5f359c1             | lea                 esi, [0xffff77d7]
            //   c5fb101d????????     |                     
            //   c5fb102d????????     |                     
            //   c4e2f1a91d????????     |     
            //   c4e2f1a92d????????     |     

        $sequence_5 = { e8???????? 837b1000 75dd 488d05fbe20000 483bd8 74d1 488bcb }
            // n = 7, score = 100
            //   e8????????           |                     
            //   837b1000             | lea                 edi, [0x7d9f]
            //   75dd                 | inc                 ebp
            //   488d05fbe20000       | mov                 eax, esi
            //   483bd8               | dec                 eax
            //   74d1                 | mov                 esi, ecx
            //   488bcb               | dec                 eax

        $sequence_6 = { 488b8b20010000 e8???????? 488db328010000 bd06000000 488d7b38 488d05b2e60000 }
            // n = 6, score = 100
            //   488b8b20010000       | mov                 eax, edx
            //   e8????????           |                     
            //   488db328010000       | and                 edx, 0x3f
            //   bd06000000           | dec                 eax
            //   488d7b38             | sar                 eax, 6
            //   488d05b2e60000       | dec                 eax

        $sequence_7 = { ff15???????? 85c0 741f 488b4c2438 488d1536a70000 ff15???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | je                  0x8fb
            //   741f                 | dec                 eax
            //   488b4c2438           | mov                 ecx, ebx
            //   488d1536a70000       | jmp                 0x8f6
            //   ff15????????         |                     

        $sequence_8 = { 7350 488bca 4c8d0591e10000 83e13f 488bc2 48c1f806 488d0cc9 }
            // n = 7, score = 100
            //   7350                 | mov                 edi, ebx
            //   488bca               | jmp                 0x1d1
            //   4c8d0591e10000       | dec                 eax
            //   83e13f               | lea                 eax, [0xffff65a2]
            //   488bc2               | dec                 edx
            //   48c1f806             | mov                 edx, dword ptr [eax + 0x17930]
            //   488d0cc9             | inc                 edx

        $sequence_9 = { 83c8ff f00fc101 83f801 751c 488b4530 488b8888000000 488d05b6000100 }
            // n = 7, score = 100
            //   83c8ff               | add                 esp, 0x10
            //   f00fc101             | pop                 ebx
            //   83f801               | ret                 
            //   751c                 | dec                 eax
            //   488b4530             | sub                 esp, 0x38
            //   488b8888000000       | dec                 eax
            //   488d05b6000100       | lea                 eax, [0x89c5]

    condition:
        7 of them and filesize < 217088
}