rule win_gophe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gophe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gophe"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 833902 0f94c0 84c0 7407 }
            // n = 4, score = 300
            //   833902               | cmp                 dword ptr [ecx], 2
            //   0f94c0               | sete                al
            //   84c0                 | test                al, al
            //   7407                 | je                  9

        $sequence_1 = { 8bf8 488b4c2440 488b01 ff5010 }
            // n = 4, score = 200
            //   8bf8                 | cmp                 eax, -1
            //   488b4c2440           | je                  0xa4
            //   488b01               | test                eax, eax
            //   ff5010               | jne                 0xb7

        $sequence_2 = { 85c0 7509 b803000000 5d c20400 }
            // n = 5, score = 200
            //   85c0                 | mov                 ecx, dword ptr [esp + 0x40]
            //   7509                 | mov                 edi, eax
            //   b803000000           | test                eax, eax
            //   5d                   | js                  0x1e
            //   c20400               | dec                 eax

        $sequence_3 = { 85c0 741c b800070000 5f }
            // n = 4, score = 200
            //   85c0                 | mov                 ecx, dword ptr [esp + 0x40]
            //   741c                 | test                ecx, ecx
            //   b800070000           | sete                al
            //   5f                   | mov                 dword ptr [ebx + 0x1c], eax

        $sequence_4 = { 8b07 85c0 7506 807e1000 7503 8a4e10 }
            // n = 6, score = 200
            //   8b07                 | sete                al
            //   85c0                 | test                al, al
            //   7506                 | je                  0xe
            //   807e1000             | jmp                 0xf
            //   7503                 | js                  0x3a
            //   8a4e10               | dec                 eax

        $sequence_5 = { 8bd8 85db 0f8498010000 83fbff }
            // n = 4, score = 200
            //   8bd8                 | test                al, al
            //   85db                 | je                  0xb
            //   0f8498010000         | jmp                 0xc
            //   83fbff               | cmp                 dword ptr [ecx], 2

        $sequence_6 = { 84c0 7407 e8???????? eb06 e8???????? 90 488d8c24b8000000 }
            // n = 7, score = 200
            //   84c0                 | dec                 eax
            //   7407                 | mov                 eax, dword ptr [edx + 0x10]
            //   e8????????           |                     
            //   eb06                 | mov                 dword ptr [eax + 8], 1
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488d8c24b8000000     | mov                 eax, dword ptr [edx + 0x10]

        $sequence_7 = { 84c0 0f8461ffffff e8???????? e9???????? }
            // n = 4, score = 200
            //   84c0                 | cmp                 dword ptr [ecx], 2
            //   0f8461ffffff         | sete                al
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_8 = { 7838 488b4c2440 ff15???????? 8bf8 85c0 7818 488b4c2440 }
            // n = 7, score = 200
            //   7838                 | dec                 eax
            //   488b4c2440           | mov                 eax, dword ptr [ecx]
            //   ff15????????         |                     
            //   8bf8                 | call                dword ptr [eax + 0x10]
            //   85c0                 | test                edi, edi
            //   7818                 | test                al, al
            //   488b4c2440           | je                  0xb

        $sequence_9 = { 8b05???????? 85c0 0f85a9000000 4533c9 4533c0 8d5010 }
            // n = 6, score = 200
            //   8b05????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85a9000000         | jne                 0xaf
            //   4533c9               | inc                 ebp
            //   4533c0               | xor                 ecx, ecx
            //   8d5010               | inc                 ebp

        $sequence_10 = { 8b442424 85c0 7408 3bc1 }
            // n = 4, score = 200
            //   8b442424             | xor                 eax, eax
            //   85c0                 | lea                 edx, [eax + 0x10]
            //   7408                 | mov                 eax, dword ptr [esp + 0x24]
            //   3bc1                 | test                eax, eax

        $sequence_11 = { 85f6 7416 6830020000 6a00 }
            // n = 4, score = 200
            //   85f6                 | test                ecx, ecx
            //   7416                 | test                al, al
            //   6830020000           | je                  0xffffff67
            //   6a00                 | mov                 ebx, eax

        $sequence_12 = { e8???????? 4883f8ff 0f849e000000 8b05???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   4883f8ff             | jne                 0xaf
            //   0f849e000000         | inc                 ebp
            //   8b05????????         |                     

        $sequence_13 = { 894614 8b4614 85c0 740a }
            // n = 4, score = 200
            //   894614               | test                ebx, ebx
            //   8b4614               | je                  0x1a0
            //   85c0                 | cmp                 ebx, -1
            //   740a                 | mov                 eax, dword ptr [edi]

        $sequence_14 = { 8b4dec 33cd e8???????? 8be5 5d c21000 c745fc02000000 }
            // n = 7, score = 200
            //   8b4dec               | test                eax, eax
            //   33cd                 | jne                 0xd
            //   e8????????           |                     
            //   8be5                 | mov                 eax, 3
            //   5d                   | pop                 ebp
            //   c21000               | ret                 4
            //   c745fc02000000       | test                eax, eax

        $sequence_15 = { c7000300150c 488b4210 c7400801000000 488b4210 }
            // n = 4, score = 200
            //   c7000300150c         | dec                 eax
            //   488b4210             | cmp                 eax, -1
            //   c7400801000000       | je                  0xa4
            //   488b4210             | test                eax, eax

    condition:
        7 of them and filesize < 1582080
}