rule win_gopuram_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gopuram."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gopuram"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd5 498bcf e8???????? 8bf0 85f6 0f8493020000 498b8e20010000 }
            // n = 7, score = 100
            //   8bd5                 | js                  0x11d2
            //   498bcf               | dec                 eax
            //   e8????????           |                     
            //   8bf0                 | lea                 ecx, [ebx + 0x48]
            //   85f6                 | dec                 eax
            //   0f8493020000         | mov                 eax, dword ptr [ecx]
            //   498b8e20010000       | dec                 eax

        $sequence_1 = { 448b64244c b801000000 4c895d88 4403e0 88442435 eb0a 448b64244c }
            // n = 7, score = 100
            //   448b64244c           | inc                 ebp
            //   b801000000           | xor                 ecx, ecx
            //   4c895d88             | inc                 ebp
            //   4403e0               | lea                 eax, [ecx + 1]
            //   88442435             | dec                 eax
            //   eb0a                 | lea                 ecx, [ebp - 0x20]
            //   448b64244c           | dec                 eax

        $sequence_2 = { 488bc8 e8???????? e9???????? 488b0d???????? 488b01 ff90f8000000 83f804 }
            // n = 7, score = 100
            //   488bc8               | mov                 esi, dword ptr [esp + 0x88]
            //   e8????????           |                     
            //   e9????????           |                     
            //   488b0d????????       |                     
            //   488b01               | dec                 eax
            //   ff90f8000000         | test                esi, esi
            //   83f804               | jne                 0x1232

        $sequence_3 = { e8???????? 8bc3 488b4d40 4833cc e8???????? 4c8d9c2450010000 498b5b38 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bc3                 | je                  0x230
            //   488b4d40             | dec                 esp
            //   4833cc               | mov                 esi, dword ptr [esp + 0x40]
            //   e8????????           |                     
            //   4c8d9c2450010000     | inc                 ebp
            //   498b5b38             | xor                 edi, edi

        $sequence_4 = { c744243800000000 e8???????? 4885c0 740f 488b4b10 488d542438 488b01 }
            // n = 7, score = 100
            //   c744243800000000     | dec                 eax
            //   e8????????           |                     
            //   4885c0               | lea                 ecx, [0xfffd8c66]
            //   740f                 | dec                 eax
            //   488b4b10             | mov                 eax, dword ptr [ebp - 0x18]
            //   488d542438           | dec                 eax
            //   488b01               | mov                 ecx, dword ptr [edi + 8]

        $sequence_5 = { c705????????03400080 c705????????f4060780 890d???????? c705????????09000380 33c0 3b7efc 7509 }
            // n = 7, score = 100
            //   c705????????03400080     |     
            //   c705????????f4060780     |     
            //   890d????????         |                     
            //   c705????????09000380     |     
            //   33c0                 | dec                 eax
            //   3b7efc               | mov                 esi, eax
            //   7509                 | mov                 ebp, eax

        $sequence_6 = { 8b4708 894114 8b470c 894118 448bfb 49c1e705 4d03fe }
            // n = 7, score = 100
            //   8b4708               | test                ebx, ebx
            //   894114               | je                  0x4bf
            //   8b470c               | dec                 eax
            //   894118               | lea                 eax, [0x452d9]
            //   448bfb               | dec                 eax
            //   49c1e705             | mov                 dword ptr [ebp - 0x11], eax
            //   4d03fe               | dec                 eax

        $sequence_7 = { 85c0 7508 41be02400080 ebd2 be01000000 33db 448be6 }
            // n = 7, score = 100
            //   85c0                 | dec                 eax
            //   7508                 | lea                 eax, [0x90e76]
            //   41be02400080         | cmp                 edi, dword ptr [eax - 4]
            //   ebd2                 | inc                 ecx
            //   be01000000           | mov                 ecx, esi
            //   33db                 | dec                 eax
            //   448be6               | lea                 eax, [0x92896]

        $sequence_8 = { b908000000 668908 83bb9800000000 0f850b010000 488b0d???????? 488b01 ff9020010000 }
            // n = 7, score = 100
            //   b908000000           | mov                 dword ptr [edi + 0x200], esi
            //   668908               | mov                 eax, ebx
            //   83bb9800000000       | dec                 esp
            //   0f850b010000         | lea                 ebx, [esp + 0x90]
            //   488b0d????????       |                     
            //   488b01               | dec                 ecx
            //   ff9020010000         | mov                 ebx, dword ptr [ebx + 0x20]

        $sequence_9 = { 85ed 0f89b1010000 0f1005???????? 4c8b05???????? 488d542460 41b902000000 b907010000 }
            // n = 7, score = 100
            //   85ed                 | xor                 eax, eax
            //   0f89b1010000         | nop                 dword ptr [eax]
            //   0f1005????????       |                     
            //   4c8b05????????       |                     
            //   488d542460           | cmp                 edi, dword ptr [esi - 4]
            //   41b902000000         | xor                 eax, eax
            //   b907010000           | cmp                 esi, dword ptr [edi - 4]

    condition:
        7 of them and filesize < 1591296
}