rule win_grabbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.grabbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grabbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb702 83f85a 770b 83f841 7206 83c020 }
            // n = 6, score = 3300
            //   0fb702               | movzx               eax, word ptr [edx]
            //   83f85a               | cmp                 eax, 0x5a
            //   770b                 | ja                  0xd
            //   83f841               | cmp                 eax, 0x41
            //   7206                 | jb                  8
            //   83c020               | add                 eax, 0x20

        $sequence_1 = { 7206 83c020 0fb7c0 83c202 }
            // n = 4, score = 3300
            //   7206                 | jb                  8
            //   83c020               | add                 eax, 0x20
            //   0fb7c0               | movzx               eax, ax
            //   83c202               | add                 edx, 2

        $sequence_2 = { 770d 83f841 7208 83c020 }
            // n = 4, score = 3300
            //   770d                 | ja                  0xf
            //   83f841               | cmp                 eax, 0x41
            //   7208                 | jb                  0xa
            //   83c020               | add                 eax, 0x20

        $sequence_3 = { 83eb14 83c314 837b0c00 7455 8b430c 034540 }
            // n = 6, score = 3200
            //   83eb14               | sub                 ebx, 0x14
            //   83c314               | add                 ebx, 0x14
            //   837b0c00             | cmp                 dword ptr [ebx + 0xc], 0
            //   7455                 | je                  0x57
            //   8b430c               | mov                 eax, dword ptr [ebx + 0xc]
            //   034540               | add                 eax, dword ptr [ebp + 0x40]

        $sequence_4 = { c745ac6f6d4173 c745b06369697a c645b400 c745b84c647247 c745bc65745072 c745c06f636564 }
            // n = 6, score = 3200
            //   c745ac6f6d4173       | mov                 dword ptr [ebp - 0x54], 0x73416d6f
            //   c745b06369697a       | mov                 dword ptr [ebp - 0x50], 0x7a696963
            //   c645b400             | mov                 byte ptr [ebp - 0x4c], 0
            //   c745b84c647247       | mov                 dword ptr [ebp - 0x48], 0x4772644c
            //   c745bc65745072       | mov                 dword ptr [ebp - 0x44], 0x72507465
            //   c745c06f636564       | mov                 dword ptr [ebp - 0x40], 0x6465636f

        $sequence_5 = { 85c9 7460 83bc188400000005 7656 8bbc18b4000000 }
            // n = 5, score = 3200
            //   85c9                 | test                ecx, ecx
            //   7460                 | je                  0x62
            //   83bc188400000005     | cmp                 dword ptr [eax + ebx + 0x84], 5
            //   7656                 | jbe                 0x58
            //   8bbc18b4000000       | mov                 edi, dword ptr [eax + ebx + 0xb4]

        $sequence_6 = { e8???????? 59 81c480000000 50 8bf1 e8???????? e8???????? }
            // n = 7, score = 3200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   81c480000000         | add                 esp, 0x80
            //   50                   | push                eax
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_7 = { 51 53 52 684b49a851 }
            // n = 4, score = 3200
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   52                   | push                edx
            //   684b49a851           | push                0x51a8494b

        $sequence_8 = { 56 ffd0 33c9 66894c37fe }
            // n = 4, score = 2600
            //   56                   | push                esi
            //   ffd0                 | call                eax
            //   33c9                 | xor                 ecx, ecx
            //   66894c37fe           | mov                 word ptr [edi + esi - 2], cx

        $sequence_9 = { 8b0d???????? 894804 8b0d???????? 894808 8b0d???????? 89480c e9???????? }
            // n = 7, score = 2300
            //   8b0d????????         |                     
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8b0d????????         |                     
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   8b0d????????         |                     
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx
            //   e9????????           |                     

        $sequence_10 = { 89480c e9???????? 33c0 e9???????? }
            // n = 4, score = 2300
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     

        $sequence_11 = { 7428 8b0d???????? 8908 8b0d???????? 894804 8b0d???????? }
            // n = 6, score = 2300
            //   7428                 | je                  0x2a
            //   8b0d????????         |                     
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b0d????????         |                     
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8b0d????????         |                     

        $sequence_12 = { 57 8d7c000c 57 e8???????? }
            // n = 4, score = 2000
            //   57                   | push                edi
            //   8d7c000c             | lea                 edi, [eax + eax + 0xc]
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_13 = { 8bf0 85f6 741d 8d4601 }
            // n = 4, score = 2000
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   741d                 | je                  0x1f
            //   8d4601               | lea                 eax, [esi + 1]

        $sequence_14 = { e8???????? 85c0 56 0f9fc3 e8???????? 83c414 }
            // n = 6, score = 2000
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   56                   | push                esi
            //   0f9fc3               | setg                bl
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_15 = { 741e 57 56 6aff }
            // n = 4, score = 2000
            //   741e                 | je                  0x20
            //   57                   | push                edi
            //   56                   | push                esi
            //   6aff                 | push                -1

    condition:
        7 of them and filesize < 1335296
}