rule win_greenshaitan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.greenshaitan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.greenshaitan"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb02 33f6 8bc5 99 }
            // n = 4, score = 100
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   8bc5                 | mov                 eax, ebp
            //   99                   | cdq                 

        $sequence_1 = { 52 ff15???????? 6804010000 8d442408 50 8d8c2414020000 51 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   6804010000           | push                0x104
            //   8d442408             | lea                 eax, [esp + 8]
            //   50                   | push                eax
            //   8d8c2414020000       | lea                 ecx, [esp + 0x214]
            //   51                   | push                ecx

        $sequence_2 = { 899fb8010000 899fbc010000 899fc0010000 899fc4010000 c644241c09 a1???????? 8b4c2428 }
            // n = 7, score = 100
            //   899fb8010000         | mov                 dword ptr [edi + 0x1b8], ebx
            //   899fbc010000         | mov                 dword ptr [edi + 0x1bc], ebx
            //   899fc0010000         | mov                 dword ptr [edi + 0x1c0], ebx
            //   899fc4010000         | mov                 dword ptr [edi + 0x1c4], ebx
            //   c644241c09           | mov                 byte ptr [esp + 0x1c], 9
            //   a1????????           |                     
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_3 = { 89742414 85ff 7521 e8???????? 33c0 }
            // n = 5, score = 100
            //   89742414             | mov                 dword ptr [esp + 0x14], esi
            //   85ff                 | test                edi, edi
            //   7521                 | jne                 0x23
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { c1e004 c1ee04 0bf0 0fb686685b6e00 41 8801 83e20f }
            // n = 7, score = 100
            //   c1e004               | shl                 eax, 4
            //   c1ee04               | shr                 esi, 4
            //   0bf0                 | or                  esi, eax
            //   0fb686685b6e00       | movzx               eax, byte ptr [esi + 0x6e5b68]
            //   41                   | inc                 ecx
            //   8801                 | mov                 byte ptr [ecx], al
            //   83e20f               | and                 edx, 0xf

        $sequence_5 = { 3974246c 720d 8b4c2458 51 e8???????? 83c404 8b542430 }
            // n = 7, score = 100
            //   3974246c             | cmp                 dword ptr [esp + 0x6c], esi
            //   720d                 | jb                  0xf
            //   8b4c2458             | mov                 ecx, dword ptr [esp + 0x58]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]

        $sequence_6 = { 6a00 50 c744245c01000000 e8???????? 837c244410 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c744245c01000000     | mov                 dword ptr [esp + 0x5c], 1
            //   e8????????           |                     
            //   837c244410           | cmp                 dword ptr [esp + 0x44], 0x10

        $sequence_7 = { ff34c584916e00 53 57 e8???????? 83c40c 85c0 740d }
            // n = 7, score = 100
            //   ff34c584916e00       | push                dword ptr [eax*8 + 0x6e9184]
            //   53                   | push                ebx
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf

        $sequence_8 = { 50 8b442420 50 51 52 57 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   52                   | push                edx
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_9 = { 0f84d1000000 57 8bcb 8d542418 e8???????? }
            // n = 5, score = 100
            //   0f84d1000000         | je                  0xd7
            //   57                   | push                edi
            //   8bcb                 | mov                 ecx, ebx
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 253952
}