rule win_grey_energy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.grey_energy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grey_energy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 53 53 6800000008 57 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6800000008           | push                0x8000000
            //   57                   | push                edi

        $sequence_1 = { 8945d4 e8???????? 68???????? 8945d0 e8???????? }
            // n = 5, score = 500
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   e8????????           |                     
            //   68????????           |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   e8????????           |                     

        $sequence_2 = { e8???????? 68???????? 8945cc e8???????? 68???????? 8945d4 e8???????? }
            // n = 7, score = 500
            //   e8????????           |                     
            //   68????????           |                     
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   e8????????           |                     
            //   68????????           |                     
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   e8????????           |                     

        $sequence_3 = { 6800000008 57 53 53 }
            // n = 4, score = 500
            //   6800000008           | push                0x8000000
            //   57                   | push                edi
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_4 = { 8b4508 0345f0 0fbe08 8b45f0 }
            // n = 4, score = 400
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0345f0               | add                 eax, dword ptr [ebp - 0x10]
            //   0fbe08               | movsx               ecx, byte ptr [eax]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_5 = { 8b45f0 8b4d08 0fb70c41 8b45f0 }
            // n = 4, score = 400
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   0fb70c41             | movzx               ecx, word ptr [ecx + eax*2]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_6 = { eb14 8b45ec 8b4df8 8b55f0 }
            // n = 4, score = 400
            //   eb14                 | jmp                 0x16
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]

        $sequence_7 = { 8b45f8 0345ec 8808 eb10 }
            // n = 4, score = 400
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   0345ec               | add                 eax, dword ptr [ebp - 0x14]
            //   8808                 | mov                 byte ptr [eax], cl
            //   eb10                 | jmp                 0x12

        $sequence_8 = { 7507 33c0 e9???????? c745f004000000 }
            // n = 4, score = 400
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   c745f004000000       | mov                 dword ptr [ebp - 0x10], 4

        $sequence_9 = { 6a40 ff15???????? 8945f8 837df800 7507 33c0 }
            // n = 6, score = 400
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax

        $sequence_10 = { 8b4df8 8b55f0 8b7508 668b1456 }
            // n = 4, score = 400
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   668b1456             | mov                 dx, word ptr [esi + edx*2]

        $sequence_11 = { 75f9 53 ff15???????? 8b75f8 }
            // n = 4, score = 400
            //   75f9                 | jne                 0xfffffffb
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]

        $sequence_12 = { 81e1ff000000 8b45ec 8b55f8 66890c42 eb14 8b45ec }
            // n = 6, score = 400
            //   81e1ff000000         | and                 ecx, 0xff
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   66890c42             | mov                 word ptr [edx + eax*2], cx
            //   eb14                 | jmp                 0x16
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_13 = { 7407 c60100 41 48 75f9 ff75f8 }
            // n = 6, score = 300
            //   7407                 | je                  9
            //   c60100               | mov                 byte ptr [ecx], 0
            //   41                   | inc                 ecx
            //   48                   | dec                 eax
            //   75f9                 | jne                 0xfffffffb
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_14 = { 742e 8d45f0 50 6a04 8d45f4 50 }
            // n = 6, score = 200
            //   742e                 | je                  0x30
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   6a04                 | push                4
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax

        $sequence_15 = { 57 ff75e8 ff75f0 ffd6 85c0 0f84b8000000 ff75fc }
            // n = 7, score = 200
            //   57                   | push                edi
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f84b8000000         | je                  0xbe
            //   ff75fc               | push                dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 303104
}