rule win_grimagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.grimagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grimagent"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec0c 8b450c 8945f8 c745fc00220400 8b4dfc 51 }
            // n = 6, score = 100
            //   83ec0c               | sub                 esp, 0xc
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   c745fc00220400       | mov                 dword ptr [ebp - 4], 0x42200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx

        $sequence_1 = { 8b550c 8955fc 8b450c 50 e8???????? 83c404 3945f8 }
            // n = 7, score = 100
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax

        $sequence_2 = { 0f8394000000 8b4df0 0fb711 8b45fc }
            // n = 4, score = 100
            //   0f8394000000         | jae                 0x9a
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   0fb711               | movzx               edx, word ptr [ecx]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_3 = { e8???????? 83c404 3945f8 750e c745e801000000 b801000000 eb1a }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   750e                 | jne                 0x10
            //   c745e801000000       | mov                 dword ptr [ebp - 0x18], 1
            //   b801000000           | mov                 eax, 1
            //   eb1a                 | jmp                 0x1c

        $sequence_4 = { 7328 8b55ec 0fb702 8b4dfc 0fb711 3bc2 7514 }
            // n = 7, score = 100
            //   7328                 | jae                 0x2a
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   0fb702               | movzx               eax, word ptr [edx]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   0fb711               | movzx               edx, word ptr [ecx]
            //   3bc2                 | cmp                 eax, edx
            //   7514                 | jne                 0x16

        $sequence_5 = { c745f801000000 ebcc 8b45fc 50 ff15???????? }
            // n = 5, score = 100
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   ebcc                 | jmp                 0xffffffce
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_6 = { 85c0 7507 c745f801000000 ebcc 8b45fc 50 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   ebcc                 | jmp                 0xffffffce
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax

        $sequence_7 = { 8b450c 50 e8???????? 83c404 3945f8 750e }
            // n = 6, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   750e                 | jne                 0x10

        $sequence_8 = { 50 e8???????? 85c0 7420 8b4d08 51 8d95f4feffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   8d95f4feffff         | lea                 edx, [ebp - 0x10c]

        $sequence_9 = { 8b4d0c 83c101 894d0c ebd0 }
            // n = 4, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   83c101               | add                 ecx, 1
            //   894d0c               | mov                 dword ptr [ebp + 0xc], ecx
            //   ebd0                 | jmp                 0xffffffd2

    condition:
        7 of them and filesize < 582656
}