rule win_gsecdump_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gsecdump."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gsecdump"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83fa10 7202 8b00 8b5314 03d0 39542430 7605 }
            // n = 7, score = 100
            //   83fa10               | cmp                 edx, 0x10
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b5314               | mov                 edx, dword ptr [ebx + 0x14]
            //   03d0                 | add                 edx, eax
            //   39542430             | cmp                 dword ptr [esp + 0x30], edx
            //   7605                 | jbe                 7

        $sequence_1 = { 894134 5d c21800 8d4104 8b48fc 8b4904 c74401fc???????? }
            // n = 7, score = 100
            //   894134               | mov                 dword ptr [ecx + 0x34], eax
            //   5d                   | pop                 ebp
            //   c21800               | ret                 0x18
            //   8d4104               | lea                 eax, [ecx + 4]
            //   8b48fc               | mov                 ecx, dword ptr [eax - 4]
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   c74401fc????????     |                     

        $sequence_2 = { bd10000000 83c408 396c242c 720d 8b442418 50 e8???????? }
            // n = 7, score = 100
            //   bd10000000           | mov                 ebp, 0x10
            //   83c408               | add                 esp, 8
            //   396c242c             | cmp                 dword ptr [esp + 0x2c], ebp
            //   720d                 | jb                  0xf
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { c6450c00 8b550c 52 8b5510 52 }
            // n = 5, score = 100
            //   c6450c00             | mov                 byte ptr [ebp + 0xc], 0
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   52                   | push                edx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   52                   | push                edx

        $sequence_4 = { 81e3fffdffff 837dd010 895d04 720c 8b45bc 50 e8???????? }
            // n = 7, score = 100
            //   81e3fffdffff         | and                 ebx, 0xfffffdff
            //   837dd010             | cmp                 dword ptr [ebp - 0x30], 0x10
            //   895d04               | mov                 dword ptr [ebp + 4], ebx
            //   720c                 | jb                  0xe
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 50 8d7b10 57 51 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d7b10               | lea                 edi, [ebx + 0x10]
            //   57                   | push                edi
            //   51                   | push                ecx

        $sequence_6 = { 57 c644242000 8b742420 56 8b742418 56 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   c644242000           | mov                 byte ptr [esp + 0x20], 0
            //   8b742420             | mov                 esi, dword ptr [esp + 0x20]
            //   56                   | push                esi
            //   8b742418             | mov                 esi, dword ptr [esp + 0x18]
            //   56                   | push                esi

        $sequence_7 = { 56 8bf0 2bf1 03f2 85c0 89742418 8d69ff }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   2bf1                 | sub                 esi, ecx
            //   03f2                 | add                 esi, edx
            //   85c0                 | test                eax, eax
            //   89742418             | mov                 dword ptr [esp + 0x18], esi
            //   8d69ff               | lea                 ebp, [ecx - 1]

        $sequence_8 = { c744241c02000000 742a 8d4704 83c9ff f00fc108 751e 8b17 }
            // n = 7, score = 100
            //   c744241c02000000     | mov                 dword ptr [esp + 0x1c], 2
            //   742a                 | je                  0x2c
            //   8d4704               | lea                 eax, [edi + 4]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f00fc108             | lock xadd           dword ptr [eax], ecx
            //   751e                 | jne                 0x20
            //   8b17                 | mov                 edx, dword ptr [edi]

        $sequence_9 = { e8???????? 8b4604 03c5 50 8d44241c 50 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   03c5                 | add                 eax, ebp
            //   50                   | push                eax
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 630784
}