rule win_hacksfase_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hacksfase."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hacksfase"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5e c9 c20400 b8???????? e8???????? 83ec40 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   b8????????           |                     
            //   e8????????           |                     
            //   83ec40               | sub                 esp, 0x40

        $sequence_1 = { 895dd0 ff5064 3bc3 894508 7d5d 3d17030980 7456 }
            // n = 7, score = 100
            //   895dd0               | mov                 dword ptr [ebp - 0x30], ebx
            //   ff5064               | call                dword ptr [eax + 0x64]
            //   3bc3                 | cmp                 eax, ebx
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   7d5d                 | jge                 0x5f
            //   3d17030980           | cmp                 eax, 0x80090317
            //   7456                 | je                  0x58

        $sequence_2 = { ff15???????? 83c418 5f 5e 81c434010000 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   83c418               | add                 esp, 0x18
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   81c434010000         | add                 esp, 0x134

        $sequence_3 = { 8bfe f3ab 8d7e40 6a04 68???????? 57 }
            // n = 6, score = 100
            //   8bfe                 | mov                 edi, esi
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d7e40               | lea                 edi, [esi + 0x40]
            //   6a04                 | push                4
            //   68????????           |                     
            //   57                   | push                edi

        $sequence_4 = { 50 e8???????? ff15???????? 834dfcff 59 8d4d94 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff15????????         |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   59                   | pop                 ecx
            //   8d4d94               | lea                 ecx, [ebp - 0x6c]
            //   e8????????           |                     

        $sequence_5 = { c20400 56 8bf1 807e1c00 740d 8b460c }
            // n = 6, score = 100
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   807e1c00             | cmp                 byte ptr [esi + 0x1c], 0
            //   740d                 | je                  0xf
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]

        $sequence_6 = { 8945e8 59 3bc3 c645fc03 7422 53 8d450b }
            // n = 7, score = 100
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   59                   | pop                 ecx
            //   3bc3                 | cmp                 eax, ebx
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   7422                 | je                  0x24
            //   53                   | push                ebx
            //   8d450b               | lea                 eax, [ebp + 0xb]

        $sequence_7 = { 0bc6 85d2 7502 0c04 6a00 50 ff15???????? }
            // n = 7, score = 100
            //   0bc6                 | or                  eax, esi
            //   85d2                 | test                edx, edx
            //   7502                 | jne                 4
            //   0c04                 | or                  al, 4
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_8 = { 57 8bd9 6a02 5f 8d4dd4 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   8bd9                 | mov                 ebx, ecx
            //   6a02                 | push                2
            //   5f                   | pop                 edi
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]

        $sequence_9 = { 5e 5b 5d c20c00 ff25???????? ff25???????? 56 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   ff25????????         |                     
            //   ff25????????         |                     
            //   56                   | push                esi

    condition:
        7 of them and filesize < 106496
}