rule win_havoc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.havoc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.havoc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7856 488b842488000000 488bb42488000000 4531c9 }
            // n = 5, score = 800
            //   85c0                 | dec                 eax
            //   7856                 | mov                 dword ptr [esp + 0x28], eax
            //   488b842488000000     | test                eax, eax
            //   488bb42488000000     | dec                 eax
            //   4531c9               | mov                 eax, dword ptr [ebx]

        $sequence_1 = { 31c0 80bc245e01000001 0f95c0 83c008 }
            // n = 4, score = 800
            //   31c0                 | movzx               edx, byte ptr [ecx + 0x1e]
            //   80bc245e01000001     | movzx               eax, byte ptr [ecx + 0x1f]
            //   0f95c0               | and                 esi, 7
            //   83c008               | jne                 0xa3

        $sequence_2 = { 49c1e504 4c01e9 4c8b01 4d85c0 }
            // n = 4, score = 800
            //   49c1e504             | dec                 eax
            //   4c01e9               | mov                 eax, dword ptr [edi]
            //   4c8b01               | inc                 esp
            //   4d85c0               | mov                 eax, dword ptr [esp + 0x3c]

        $sequence_3 = { 89f8 5b 5e 5f 5d 415c }
            // n = 6, score = 800
            //   89f8                 | inc                 ecx
            //   5b                   | mov                 eax, 0x42
            //   5e                   | dec                 eax
            //   5f                   | mov                 ecx, ebp
            //   5d                   | call                dword ptr [eax + 0x164]
            //   415c                 | jmp                 0x1b0c

        $sequence_4 = { 4181c0ff0f0000 488b00 4181e000f0ffff 4889542420 4889ca 4883c9ff }
            // n = 6, score = 800
            //   4181c0ff0f0000       | mov                 eax, dword ptr [eax]
            //   488b00               | dec                 eax
            //   4181e000f0ffff       | mov                 ecx, dword ptr [ebx + 0x18]
            //   4889542420           | dec                 eax
            //   4889ca               | test                ecx, ecx
            //   4883c9ff             | je                  0x15f9

        $sequence_5 = { 6bc018 44898424c4000000 48c78424c800000001001800 f3a5 83c01f }
            // n = 5, score = 800
            //   6bc018               | mov                 ecx, 1
            //   44898424c4000000     | dec                 eax
            //   48c78424c800000001001800     | mov    dword ptr [esp + 0x30], edx
            //   f3a5                 | dec                 eax
            //   83c01f               | lea                 edx, [esp + 0x30]

        $sequence_6 = { 85f6 0f95c0 4883c9ff 01c0 8944244c }
            // n = 5, score = 800
            //   85f6                 | mov                 dword ptr [esp + 0x48], eax
            //   0f95c0               | dec                 eax
            //   4883c9ff             | arpl                word ptr [ecx + 0x3c], ax
            //   01c0                 | dec                 eax
            //   8944244c             | add                 eax, ecx

        $sequence_7 = { 4d8b0c3a 48c1e204 4b8d0c01 8b01 49034412f0 4b8d540104 }
            // n = 6, score = 800
            //   4d8b0c3a             | mov                 dword ptr [edx + 0x41c], eax
            //   48c1e204             | dec                 eax
            //   4b8d0c01             | mov                 ecx, dword ptr [edx + 0x634]
            //   8b01                 | mov                 edx, 0xce4cd9cb
            //   49034412f0           | dec                 eax
            //   4b8d540104           | mov                 edx, dword ptr [ebx]

        $sequence_8 = { 4531c0 31d2 e8???????? 4883c428 }
            // n = 4, score = 800
            //   4531c0               | inc                 ecx
            //   31d2                 | mov                 eax, dword ptr [esp]
            //   e8????????           |                     
            //   4883c428             | test                eax, eax

        $sequence_9 = { 85c0 7856 488b842488000000 488bb42488000000 4531c9 4531c0 488b8c24a0000000 }
            // n = 7, score = 800
            //   85c0                 | dec                 eax
            //   7856                 | or                  ecx, 0xffffffff
            //   488b842488000000     | dec                 eax
            //   488bb42488000000     | mov                 dword ptr [esp + 0x20], 0
            //   4531c9               | inc                 ecx
            //   4531c0               | mov                 ecx, 0x38
            //   488b8c24a0000000     | call                dword ptr [eax + 0x5c4]

    condition:
        7 of them and filesize < 164864
}