rule win_himera_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.himera_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.himera_loader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8060964200 8945e4 803800 8bc8 }
            // n = 4, score = 200
            //   8d8060964200         | lea                 eax, [eax + 0x429660]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   803800               | cmp                 byte ptr [eax], 0
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { 895594 894db0 8b048d00a14200 8975b4 8b440618 8b7514 }
            // n = 6, score = 200
            //   895594               | mov                 dword ptr [ebp - 0x6c], edx
            //   894db0               | mov                 dword ptr [ebp - 0x50], ecx
            //   8b048d00a14200       | mov                 eax, dword ptr [ecx*4 + 0x42a100]
            //   8975b4               | mov                 dword ptr [ebp - 0x4c], esi
            //   8b440618             | mov                 eax, dword ptr [esi + eax + 0x18]
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]

        $sequence_2 = { 8b4df8 8b55f4 8b048d00a14200 807c102800 }
            // n = 4, score = 200
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b048d00a14200       | mov                 eax, dword ptr [ecx*4 + 0x42a100]
            //   807c102800           | cmp                 byte ptr [eax + edx + 0x28], 0

        $sequence_3 = { 0f57c9 f20f2aca 0f57c0 f20f2ac1 c1e91f f20f590d???????? f20f5804cd606f4200 }
            // n = 7, score = 200
            //   0f57c9               | xorps               xmm1, xmm1
            //   f20f2aca             | cvtsi2sd            xmm1, edx
            //   0f57c0               | xorps               xmm0, xmm0
            //   f20f2ac1             | cvtsi2sd            xmm0, ecx
            //   c1e91f               | shr                 ecx, 0x1f
            //   f20f590d????????     |                     
            //   f20f5804cd606f4200     | addsd    xmm0, qword ptr [ecx*8 + 0x426f60]

        $sequence_4 = { 8d45f4 64a300000000 894de4 c745e008000000 c645e801 }
            // n = 5, score = 200
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   c745e008000000       | mov                 dword ptr [ebp - 0x20], 8
            //   c645e801             | mov                 byte ptr [ebp - 0x18], 1

        $sequence_5 = { c645e557 c645e65a c645e746 c645e841 }
            // n = 4, score = 200
            //   c645e557             | mov                 byte ptr [ebp - 0x1b], 0x57
            //   c645e65a             | mov                 byte ptr [ebp - 0x1a], 0x5a
            //   c645e746             | mov                 byte ptr [ebp - 0x19], 0x46
            //   c645e841             | mov                 byte ptr [ebp - 0x18], 0x41

        $sequence_6 = { 6bf838 894df4 8b048d00a14200 c745f00a000000 8b540718 8955e0 }
            // n = 6, score = 200
            //   6bf838               | imul                edi, eax, 0x38
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8b048d00a14200       | mov                 eax, dword ptr [ecx*4 + 0x42a100]
            //   c745f00a000000       | mov                 dword ptr [ebp - 0x10], 0xa
            //   8b540718             | mov                 edx, dword ptr [edi + eax + 0x18]
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx

        $sequence_7 = { 8b55f0 8b048500a14200 807c022800 7da9 807dff02 }
            // n = 5, score = 200
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8b048500a14200       | mov                 eax, dword ptr [eax*4 + 0x42a100]
            //   807c022800           | cmp                 byte ptr [edx + eax + 0x28], 0
            //   7da9                 | jge                 0xffffffab
            //   807dff02             | cmp                 byte ptr [ebp - 1], 2

        $sequence_8 = { 8b404c 83b8a800000000 750e 8b04bd00a14200 807c302900 }
            // n = 5, score = 200
            //   8b404c               | mov                 eax, dword ptr [eax + 0x4c]
            //   83b8a800000000       | cmp                 dword ptr [eax + 0xa8], 0
            //   750e                 | jne                 0x10
            //   8b04bd00a14200       | mov                 eax, dword ptr [edi*4 + 0x42a100]
            //   807c302900           | cmp                 byte ptr [eax + esi + 0x29], 0

        $sequence_9 = { 8b45fc 83c001 8945fc 837dfc12 7318 8b4d08 }
            // n = 6, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c001               | add                 eax, 1
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc12             | cmp                 dword ptr [ebp - 4], 0x12
            //   7318                 | jae                 0x1a
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 385024
}