rule win_hive_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hive."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hive"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b807000000 b9d4000000 31d2 31db }
            // n = 4, score = 300
            //   b807000000           | inc                 eax
            //   b9d4000000           | movzx               edx, dh
            //   31d2                 | add                 eax, ecx
            //   31db                 | shl                 eax, 6

        $sequence_1 = { 31c0 b9aa000000 31d2 31db }
            // n = 4, score = 300
            //   31c0                 | inc                 eax
            //   b9aa000000           | movzx               ecx, bh
            //   31d2                 | add                 ecx, eax
            //   31db                 | shl                 ecx, 6

        $sequence_2 = { 31c0 6690 e8???????? 85c0 7569 }
            // n = 5, score = 200
            //   31c0                 | jg                  9
            //   6690                 | mov                 edx, 1
            //   e8????????           |                     
            //   85c0                 | jmp                 0x20
            //   7569                 | cmp                 edx, 2

        $sequence_3 = { 7f1e 0fbae000 73ed 90 66c74424426341 66c74424400000 }
            // n = 6, score = 200
            //   7f1e                 | jbe                 0x18
            //   0fbae000             | mov                 dword ptr [esp + 0x88], ecx
            //   73ed                 | mov                 dword ptr [esp + 0x8c], eax
            //   90                   | add                 esp, 0x78
            //   66c74424426341       | ret                 
            //   66c74424400000       | test                ebx, ebx

        $sequence_4 = { 31c0 31c9 31d2 bb04000000 beb8000000 31ff }
            // n = 6, score = 200
            //   31c0                 | mov                 edx, eax
            //   31c9                 | mov                 eax, 1
            //   31d2                 | nop                 
            //   bb04000000           | add                 esp, 0xb0
            //   beb8000000           | ret                 
            //   31ff                 | nop                 

        $sequence_5 = { 89c2 e8???????? b801000000 e8???????? 90 }
            // n = 5, score = 200
            //   89c2                 | dec                 ebp
            //   e8????????           |                     
            //   b801000000           | test                edi, edi
            //   e8????????           |                     
            //   90                   | add                 edx, ecx

        $sequence_6 = { 89d1 e8???????? b802000000 e8???????? b802000000 }
            // n = 5, score = 200
            //   89d1                 | shl                 edx, 6
            //   e8????????           |                     
            //   b802000000           | movzx               eax, bl
            //   e8????????           |                     
            //   b802000000           | add                 eax, edx

        $sequence_7 = { 31c0 31c9 31d2 bb06000000 be41000000 31ff }
            // n = 6, score = 200
            //   31c0                 | xor                 ebx, ebx
            //   31c9                 | xor                 esi, esi
            //   31d2                 | xor                 edi, edi
            //   bb06000000           | jmp                 0x26
            //   be41000000           | xor                 eax, eax
            //   31ff                 | xor                 ecx, ecx

        $sequence_8 = { 31c0 e8???????? e8???????? 833d????????00 750e }
            // n = 5, score = 200
            //   31c0                 | jg                  0x20
            //   e8????????           |                     
            //   e8????????           |                     
            //   833d????????00       |                     
            //   750e                 | bt                  eax, 0

        $sequence_9 = { 31c0 eb13 0fb654044b 0fb674041e }
            // n = 4, score = 200
            //   31c0                 | mov                 eax, 7
            //   eb13                 | mov                 ecx, 0xd4
            //   0fb654044b           | xor                 edx, edx
            //   0fb674041e           | xor                 ebx, ebx

        $sequence_10 = { 81c4b0000000 c3 e8???????? 90 }
            // n = 4, score = 200
            //   81c4b0000000         | shl                 edx, 6
            //   c3                   | movzx               eax, bl
            //   e8????????           |                     
            //   90                   | add                 eax, edx

        $sequence_11 = { 89d1 e8???????? b901000000 e8???????? }
            // n = 4, score = 200
            //   89d1                 | shl                 edx, 6
            //   e8????????           |                     
            //   b901000000           | movzx               eax, bl
            //   e8????????           |                     

        $sequence_12 = { 01c1 c1e106 400fb6d6 01ca }
            // n = 4, score = 100
            //   01c1                 | add                 ecx, eax
            //   c1e106               | shl                 ecx, 6
            //   400fb6d6             | movzx               eax, dl
            //   01ca                 | add                 eax, ecx

        $sequence_13 = { 01c0 4000f8 0fb6c0 48898424b0000000 }
            // n = 4, score = 100
            //   01c0                 | add                 eax, eax
            //   4000f8               | inc                 eax
            //   0fb6c0               | add                 al, bh
            //   48898424b0000000     | movzx               eax, al

        $sequence_14 = { 01c8 89c1 c1e91f ffc9 }
            // n = 4, score = 100
            //   01c8                 | movzx               eax, bl
            //   89c1                 | add                 eax, edx
            //   c1e91f               | add                 edx, eax
            //   ffc9                 | mov                 eax, 0x3ffffff

        $sequence_15 = { 01c2 b8ffffff03 21c5 21c3 }
            // n = 4, score = 100
            //   01c2                 | inc                 eax
            //   b8ffffff03           | movzx               edx, dh
            //   21c5                 | add                 edx, ecx
            //   21c3                 | add                 ecx, eax

        $sequence_16 = { 01c8 c1e006 400fb6cf 01c1 }
            // n = 4, score = 100
            //   01c8                 | and                 ecx, eax
            //   c1e006               | inc                 ecx
            //   400fb6cf             | mov                 dword ptr [edi + 0x14], ecx
            //   01c1                 | add                 eax, ecx

        $sequence_17 = { 01c1 c1e106 0fb6c2 01c8 }
            // n = 4, score = 100
            //   01c1                 | jb                  0xfffffe9c
            //   c1e106               | mov                 edx, 5
            //   0fb6c2               | add                 ecx, eax
            //   01c8                 | add                 ecx, 1

        $sequence_18 = { 01c1 83c101 83f90c 0f820fffffff }
            // n = 4, score = 100
            //   01c1                 | je                  0x277
            //   83c101               | add                 eax, eax
            //   83f90c               | inc                 eax
            //   0f820fffffff         | add                 al, bh

        $sequence_19 = { 01ca c1e206 0fb6c3 01d0 }
            // n = 4, score = 100
            //   01ca                 | mov                 ecx, eax
            //   c1e206               | shr                 ecx, 0x1f
            //   0fb6c3               | dec                 ecx
            //   01d0                 | inc                 ecx

        $sequence_20 = { 898c2488000000 8984248c000000 83c478 c3 85db 7609 }
            // n = 6, score = 100
            //   898c2488000000       | add                 eax, edx
            //   8984248c000000       | dec                 ebp
            //   83c478               | test                edi, edi
            //   c3                   | je                  0xfffffd65
            //   85db                 | inc                 ecx
            //   7609                 | mov                 eax, eax

    condition:
        7 of them and filesize < 7946240
}