rule win_hookinjex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hookinjex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hookinjex"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? b80a020000 eb02 33c0 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   b80a020000           | mov                 dword ptr [esp + 0x20], eax
            //   eb02                 | mov                 eax, dword ptr [esp + 0x20]
            //   33c0                 | mov                 dword ptr [esp + 0x48], eax

        $sequence_1 = { e8???????? 85c0 7408 803b00 7403 48ffc3 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   85c0                 | mov                 dword ptr [esp + 0x20], eax
            //   7408                 | mov                 eax, dword ptr [esp + 0x20]
            //   803b00               | mov                 dword ptr [esp + 0x8c], eax
            //   7403                 | mov                 eax, dword ptr [esp + 0x28]
            //   48ffc3               | and                 eax, 0xffff9fff

        $sequence_2 = { e8???????? 85c0 740f b907b60000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   85c0                 | je                  0xa
            //   740f                 | cmp                 byte ptr [ebx], 0
            //   b907b60000           | je                  0xa

        $sequence_3 = { e8???????? 833d????????00 7411 b906000000 e8???????? 488905???????? c705????????01000000 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7411                 | mov                 eax, dword ptr [esp + 0x20]
            //   b906000000           | mov                 dword ptr [esp + 0x48], eax
            //   e8????????           |                     
            //   488905????????       |                     
            //   c705????????01000000     |     

        $sequence_4 = { e8???????? 85c0 740c b913e40000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   85c0                 | and                 eax, 0xffffe7ff
            //   740c                 | bts                 eax, 0xb
            //   b913e40000           | mov                 dword ptr [esp + 0x20], eax

        $sequence_5 = { e8???????? 833d????????00 7411 b903000000 e8???????? 488905???????? }
            // n = 6, score = 300
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7411                 | bts                 eax, 0xb
            //   b903000000           | mov                 dword ptr [esp + 0x20], eax
            //   e8????????           |                     
            //   488905????????       |                     

        $sequence_6 = { e9???????? 488b4c2458 e8???????? 488b4c2450 }
            // n = 4, score = 300
            //   e9????????           |                     
            //   488b4c2458           | and                 eax, 0xffffe7ff
            //   e8????????           |                     
            //   488b4c2450           | bts                 eax, 0xb

        $sequence_7 = { e8???????? 85c0 750f b9dc550100 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   85c0                 | mov                 dword ptr [esp + 0x20], eax
            //   750f                 | mov                 eax, dword ptr [esp + 0x20]
            //   b9dc550100           | mov                 dword ptr [esp + 0x8c], eax

        $sequence_8 = { 25ff9fffff 89442420 8b442420 89442448 }
            // n = 4, score = 200
            //   25ff9fffff           | lea                 ecx, [esp + 0x30]
            //   89442420             | je                  0x143
            //   8b442420             | dec                 eax
            //   89442448             | mov                 eax, dword ptr [esp + 0x40]

        $sequence_9 = { 0f843d010000 488b442440 488b4c2470 488b4920 }
            // n = 4, score = 200
            //   0f843d010000         | dec                 eax
            //   488b442440           | lea                 ecx, [esp + 0x310]
            //   488b4c2470           | dec                 eax
            //   488b4920             | mov                 dword ptr [esp + 0x260], eax

        $sequence_10 = { 0f84c0000000 48833d????????00 0f84b2000000 41b810000000 488d9424d8000000 }
            // n = 5, score = 200
            //   0f84c0000000         | je                  0xc6
            //   48833d????????00     |                     
            //   0f84b2000000         | je                  0xb8
            //   41b810000000         | inc                 ecx
            //   488d9424d8000000     | mov                 eax, 0x10

        $sequence_11 = { 0f8430010000 488d8c2410030000 e8???????? 4889842460020000 41b07b }
            // n = 5, score = 200
            //   0f8430010000         | je                  0xc6
            //   488d8c2410030000     | je                  0xb8
            //   e8????????           |                     
            //   4889842460020000     | inc                 ecx
            //   41b07b               | mov                 eax, 0x10

        $sequence_12 = { 25ff0f0000 89442448 488b0d???????? 48894c2450 }
            // n = 4, score = 200
            //   25ff0f0000           | mov                 ecx, dword ptr [esp + 0x668]
            //   89442448             | add                 eax, dword ptr [esp + 0x60]
            //   488b0d????????       |                     
            //   48894c2450           | dec                 eax

        $sequence_13 = { 03442460 488b4c2468 8901 e9???????? 488b542470 488d4c2430 }
            // n = 6, score = 200
            //   03442460             | je                  0x136
            //   488b4c2468           | dec                 eax
            //   8901                 | lea                 ecx, [esp + 0x310]
            //   e9????????           |                     
            //   488b542470           | dec                 eax
            //   488d4c2430           | mov                 dword ptr [esp + 0x260], eax

        $sequence_14 = { 253fffffff 89842488000000 eb10 8b442420 }
            // n = 4, score = 200
            //   253fffffff           | and                 eax, 0xffffff3f
            //   89842488000000       | mov                 dword ptr [esp + 0x88], eax
            //   eb10                 | jmp                 0x12
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]

        $sequence_15 = { 25c0000000 83f840 750d c78424dc01000001000000 }
            // n = 4, score = 200
            //   25c0000000           | mov                 eax, 0x10
            //   83f840               | dec                 eax
            //   750d                 | lea                 edx, [esp + 0xd8]
            //   c78424dc01000001000000     | dec    eax

    condition:
        7 of them and filesize < 6545408
}