rule win_httpsuploader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.httpsuploader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.httpsuploader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33ff 33d2 41b806020000 6689bc2470020000 e8???????? 488d4c2451 33d2 }
            // n = 7, score = 100
            //   33ff                 | dec                 ecx
            //   33d2                 | mov                 ecx, dword ptr [edi + ecx]
            //   41b806020000         | dec                 esp
            //   6689bc2470020000     | lea                 ecx, [esp + 0x48]
            //   e8????????           |                     
            //   488d4c2451           | dec                 eax
            //   33d2                 | lea                 ecx, [0x8ddf]

        $sequence_1 = { 33d2 33c9 897c2428 48895c2420 ff15???????? eb3b 488d0dc3bd0000 }
            // n = 7, score = 100
            //   33d2                 | mov                 eax, ebp
            //   33c9                 | and                 ebp, 0x1f
            //   897c2428             | dec                 eax
            //   48895c2420           | sar                 eax, 5
            //   ff15????????         |                     
            //   eb3b                 | dec                 eax
            //   488d0dc3bd0000       | imul                ebp, ebp, 0x58

        $sequence_2 = { 4883ec20 488bfa 488bd9 488d0501700000 488981a0000000 83611000 }
            // n = 6, score = 100
            //   4883ec20             | mov                 ecx, 0x40
            //   488bfa               | dec                 esp
            //   488bd9               | mov                 dword ptr [esp + 0x498], ebp
            //   488d0501700000       | mov                 dword ptr [esp + 0x20], 3
            //   488981a0000000       | dec                 esp
            //   83611000             | mov                 ebp, eax

        $sequence_3 = { 4c8bc0 418bd4 e8???????? 488d8dd0000000 ff15???????? }
            // n = 5, score = 100
            //   4c8bc0               | dec                 eax
            //   418bd4               | mov                 ecx, dword ptr [ebp + 0x2e0]
            //   e8????????           |                     
            //   488d8dd0000000       | dec                 eax
            //   ff15????????         |                     

        $sequence_4 = { 488d0d6c280000 4533c9 ba00000040 4489442420 ff15???????? }
            // n = 5, score = 100
            //   488d0d6c280000       | movzx               eax, byte ptr [eax + ebp]
            //   4533c9               | inc                 ecx
            //   ba00000040           | mov                 byte ptr [edx], al
            //   4489442420           | mov                 eax, ecx
            //   ff15????????         |                     

        $sequence_5 = { 4c8d25cf7d0000 f0ff09 7511 488b8eb8000000 493bcc }
            // n = 5, score = 100
            //   4c8d25cf7d0000       | mov                 eax, 0x3fe
            //   f0ff09               | mov                 word ptr [ebp + 0x4f0], di
            //   7511                 | dec                 eax
            //   488b8eb8000000       | lea                 ecx, [ebp + 0x8f2]
            //   493bcc               | xor                 edx, edx

        $sequence_6 = { 488d0543b50000 eb04 4883c014 4883c428 c3 4053 }
            // n = 6, score = 100
            //   488d0543b50000       | inc                 ecx
            //   eb04                 | dec                 ecx
            //   4883c014             | dec                 ecx
            //   4883c428             | jne                 0x62
            //   c3                   | movzx               ecx, byte ptr [esp + 0x18]
            //   4053                 | mov                 byte ptr [ecx], 0

        $sequence_7 = { 488d158e380000 488bc8 ff15???????? 4885c0 0f847a010000 }
            // n = 5, score = 100
            //   488d158e380000       | lea                 eax, [0xde96]
            //   488bc8               | xor                 eax, eax
            //   ff15????????         |                     
            //   4885c0               | mov                 ebp, eax
            //   0f847a010000         | inc                 ebp

        $sequence_8 = { 81fa01010000 7d13 4863ca 8a44191c 4288840170fa0000 }
            // n = 5, score = 100
            //   81fa01010000         | dec                 eax
            //   7d13                 | arpl                si, cx
            //   4863ca               | dec                 eax
            //   8a44191c             | lea                 edx, [ebp + ecx + 0x620]
            //   4288840170fa0000     | inc                 ebp

        $sequence_9 = { 745e 6666660f1f840000000000 488b0d???????? 488d542440 4533c9 4533c0 ff15???????? }
            // n = 7, score = 100
            //   745e                 | inc                 ecx
            //   6666660f1f840000000000     | lea    eax, [esp + 1]
            //   488b0d????????       |                     
            //   488d542440           | mov                 edx, eax
            //   4533c9               | mov                 ebx, eax
            //   4533c0               | dec                 esp
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 190464
}