rule win_ismagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ismagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ismagent"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89442448 8bf0 83c404 2bf2 }
            // n = 4, score = 200
            //   89442448             | mov                 dword ptr [esp + 0x48], eax
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   2bf2                 | sub                 esi, edx

        $sequence_1 = { 2bce 3bd1 72e2 83ff04 750a }
            // n = 5, score = 200
            //   2bce                 | sub                 ecx, esi
            //   3bd1                 | cmp                 edx, ecx
            //   72e2                 | jb                  0xffffffe4
            //   83ff04               | cmp                 edi, 4
            //   750a                 | jne                 0xc

        $sequence_2 = { 5d c3 8b85b8f3ffff 33db 899dc0f3ffff c60000 85c9 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b85b8f3ffff         | mov                 eax, dword ptr [ebp - 0xc48]
            //   33db                 | xor                 ebx, ebx
            //   899dc0f3ffff         | mov                 dword ptr [ebp - 0xc40], ebx
            //   c60000               | mov                 byte ptr [eax], 0
            //   85c9                 | test                ecx, ecx

        $sequence_3 = { 8d4901 88840c1f130000 84c0 75ec 33c9 8a840c380f0000 }
            // n = 6, score = 200
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   88840c1f130000       | mov                 byte ptr [esp + ecx + 0x131f], al
            //   84c0                 | test                al, al
            //   75ec                 | jne                 0xffffffee
            //   33c9                 | xor                 ecx, ecx
            //   8a840c380f0000       | mov                 al, byte ptr [esp + ecx + 0xf38]

        $sequence_4 = { 8d5201 888c14ff060000 84c9 75ec }
            // n = 4, score = 200
            //   8d5201               | lea                 edx, [edx + 1]
            //   888c14ff060000       | mov                 byte ptr [esp + edx + 0x6ff], cl
            //   84c9                 | test                cl, cl
            //   75ec                 | jne                 0xffffffee

        $sequence_5 = { 8b4c2434 8d942418070000 50 6a01 }
            // n = 4, score = 200
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   8d942418070000       | lea                 edx, [esp + 0x718]
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_6 = { 8dbc2428650000 2bd6 4f 0f1f8000000000 8a4701 }
            // n = 5, score = 200
            //   8dbc2428650000       | lea                 edi, [esp + 0x6528]
            //   2bd6                 | sub                 edx, esi
            //   4f                   | dec                 edi
            //   0f1f8000000000       | nop                 dword ptr [eax]
            //   8a4701               | mov                 al, byte ptr [edi + 1]

        $sequence_7 = { 8d8424580b0000 50 e8???????? 83c40c 8d842418030000 68e8030000 50 }
            // n = 7, score = 200
            //   8d8424580b0000       | lea                 eax, [esp + 0xb58]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d842418030000       | lea                 eax, [esp + 0x318]
            //   68e8030000           | push                0x3e8
            //   50                   | push                eax

    condition:
        7 of them and filesize < 327680
}