rule win_jcry_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jcry"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b442424 8907 8d0560434f00 890424 c74424040d000000 c744240800000000 }
            // n = 6, score = 100
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8d0560434f00         | lea                 eax, [0x4f4360]
            //   890424               | mov                 dword ptr [esp], eax
            //   c74424040d000000     | mov                 dword ptr [esp + 4], 0xd
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0

        $sequence_1 = { c744240400000000 e8???????? 8b44240c 8b4c2408 8d1500a44f00 891424 894c2404 }
            // n = 7, score = 100
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   e8????????           |                     
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8d1500a44f00         | lea                 edx, [0x4fa400]
            //   891424               | mov                 dword ptr [esp], edx
            //   894c2404             | mov                 dword ptr [esp + 4], ecx

        $sequence_2 = { 890c24 8b542420 89542404 8d1de6fd5000 895c2408 c744240c0a000000 e8???????? }
            // n = 7, score = 100
            //   890c24               | mov                 dword ptr [esp], ecx
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   8d1de6fd5000         | lea                 ebx, [0x50fde6]
            //   895c2408             | mov                 dword ptr [esp + 8], ebx
            //   c744240c0a000000     | mov                 dword ptr [esp + 0xc], 0xa
            //   e8????????           |                     

        $sequence_3 = { ebdd 89442434 8d0540d34e00 890424 895c2404 89542408 896c240c }
            // n = 7, score = 100
            //   ebdd                 | jmp                 0xffffffdf
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   8d0540d34e00         | lea                 eax, [0x4ed340]
            //   890424               | mov                 dword ptr [esp], eax
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   896c240c             | mov                 dword ptr [esp + 0xc], ebp

        $sequence_4 = { 0f0b e8???????? 0f0b 8d05bc415100 890424 c74424041a000000 e8???????? }
            // n = 7, score = 100
            //   0f0b                 | ud2                 
            //   e8????????           |                     
            //   0f0b                 | ud2                 
            //   8d05bc415100         | lea                 eax, [0x5141bc]
            //   890424               | mov                 dword ptr [esp], eax
            //   c74424041a000000     | mov                 dword ptr [esp + 4], 0x1a
            //   e8????????           |                     

        $sequence_5 = { 8b4c2448 894c242c 890424 c744240404000000 8b442434 89442408 8b442430 }
            // n = 7, score = 100
            //   8b4c2448             | mov                 ecx, dword ptr [esp + 0x48]
            //   894c242c             | mov                 dword ptr [esp + 0x2c], ecx
            //   890424               | mov                 dword ptr [esp], eax
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]

        $sequence_6 = { 897c2434 8d44f108 8b00 89442430 e8???????? 8d0527845100 890424 }
            // n = 7, score = 100
            //   897c2434             | mov                 dword ptr [esp + 0x34], edi
            //   8d44f108             | lea                 eax, [ecx + esi*8 + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   e8????????           |                     
            //   8d0527845100         | lea                 eax, [0x518427]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_7 = { 8b442468 83f80a 0f85f8030000 8d0540425e00 890424 e8???????? 8d0548425e00 }
            // n = 7, score = 100
            //   8b442468             | mov                 eax, dword ptr [esp + 0x68]
            //   83f80a               | cmp                 eax, 0xa
            //   0f85f8030000         | jne                 0x3fe
            //   8d0540425e00         | lea                 eax, [0x5e4240]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8d0548425e00         | lea                 eax, [0x5e4248]

        $sequence_8 = { 8b6c2430 eb93 8d0da0275000 890c24 8b6c2438 896c2404 }
            // n = 6, score = 100
            //   8b6c2430             | mov                 ebp, dword ptr [esp + 0x30]
            //   eb93                 | jmp                 0xffffff95
            //   8d0da0275000         | lea                 ecx, [0x5027a0]
            //   890c24               | mov                 dword ptr [esp], ecx
            //   8b6c2438             | mov                 ebp, dword ptr [esp + 0x38]
            //   896c2404             | mov                 dword ptr [esp + 4], ebp

        $sequence_9 = { 8b4c243c 89c2 89c8 89d1 e9???????? 8d05aef65000 b907000000 }
            // n = 7, score = 100
            //   8b4c243c             | mov                 ecx, dword ptr [esp + 0x3c]
            //   89c2                 | mov                 edx, eax
            //   89c8                 | mov                 eax, ecx
            //   89d1                 | mov                 ecx, edx
            //   e9????????           |                     
            //   8d05aef65000         | lea                 eax, [0x50f6ae]
            //   b907000000           | mov                 ecx, 7

    condition:
        7 of them and filesize < 4137984
}