rule win_kapeka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kapeka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kapeka"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 448b642424 be16000000 448d76eb 488b4b70 488d542420 488b01 }
            // n = 6, score = 100
            //   448b642424           | inc                 ecx
            //   be16000000           | mov                 eax, eax
            //   448d76eb             | inc                 ecx
            //   488b4b70             | xor                 ebx, dword ptr [edi + 0x34]
            //   488d542420           | shr                 eax, 0x10
            //   488b01               | inc                 ecx

        $sequence_1 = { 488bd8 e8???????? 488d8c2480000000 4533c9 48894c2428 4533c0 498b0e }
            // n = 7, score = 100
            //   488bd8               | test                eax, eax
            //   e8????????           |                     
            //   488d8c2480000000     | dec                 eax
            //   4533c9               | mov                 eax, edi
            //   48894c2428           | dec                 eax
            //   4533c0               | cmp                 ebx, eax
            //   498b0e               | ja                  0x883

        $sequence_2 = { 4885c0 0f8422050000 4889b42460010000 4c8d2d71a10000 498bcd 4c89a42470010000 4c89bc2430010000 }
            // n = 7, score = 100
            //   4885c0               | inc                 ebp
            //   0f8422050000         | xor                 bh, bh
            //   4889b42460010000     | dec                 eax
            //   4c8d2d71a10000       | lea                 edx, [esp + 0x80]
            //   498bcd               | dec                 eax
            //   4c89a42470010000     | mov                 ecx, eax
            //   4c89bc2430010000     | dec                 esp

        $sequence_3 = { 397537 7549 0f1045d7 0f1145e7 488b4de7 6690 0fb701 }
            // n = 7, score = 100
            //   397537               | dec                 eax
            //   7549                 | mov                 dword ptr [esp + 0x48], ebp
            //   0f1045d7             | dec                 esp
            //   0f1145e7             | mov                 dword ptr [esp + 0x20], esi
            //   488b4de7             | nop                 word ptr [eax + eax]
            //   6690                 | je                  0xa2
            //   0fb701               | dec                 esp

        $sequence_4 = { 44335e08 4533da 4133fb 44895840 448bd7 897844 4533d1 }
            // n = 7, score = 100
            //   44335e08             | dec                 eax
            //   4533da               | lea                 eax, [0x19313]
            //   4133fb               | dec                 eax
            //   44895840             | mov                 ebx, ecx
            //   448bd7               | dec                 eax
            //   897844               | mov                 dword ptr [ecx], eax
            //   4533d1               | dec                 eax

        $sequence_5 = { c744242019010200 4c8d451f 48c7c102000080 488d55f7 e8???????? }
            // n = 5, score = 100
            //   c744242019010200     | mov                 ecx, edi
            //   4c8d451f             | dec                 eax
            //   48c7c102000080       | mov                 eax, dword ptr [ebx]
            //   488d55f7             | dec                 eax
            //   e8????????           |                     

        $sequence_6 = { 48f7e1 8bc7 48c1ea1f 480fafd7 482bca 2bc1 4181f8fdffff7f }
            // n = 7, score = 100
            //   48f7e1               | dec                 eax
            //   8bc7                 | lea                 edx, [0x150f2]
            //   48c1ea1f             | dec                 ecx
            //   480fafd7             | mov                 ecx, edi
            //   482bca               | dec                 eax
            //   2bc1                 | lea                 edx, [0x15147]
            //   4181f8fdffff7f       | dec                 eax

        $sequence_7 = { 488bd9 488901 33ff 488b4928 4885c9 740a }
            // n = 6, score = 100
            //   488bd9               | dec                 eax
            //   488901               | mov                 ebx, dword ptr [esp + 0x30]
            //   33ff                 | dec                 eax
            //   488b4928             | add                 esp, 0x20
            //   4885c9               | dec                 eax
            //   740a                 | mov                 ecx, ebx

        $sequence_8 = { 4885c9 7406 ff15???????? 488b5e18 488d4e20 e8???????? 488bd3 }
            // n = 7, score = 100
            //   4885c9               | inc                 ebp
            //   7406                 | xor                 eax, dword ptr [esp + eax*4 + 0x1f270]
            //   ff15????????         |                     
            //   488b5e18             | inc                 ebp
            //   488d4e20             | xor                 eax, dword ptr [esi + 0x6c]
            //   e8????????           |                     
            //   488bd3               | inc                 ecx

        $sequence_9 = { 41b802000000 488d95b0010000 488d8d00010000 e8???????? 488d8d28010000 e8???????? 488d0dc0650100 }
            // n = 7, score = 100
            //   41b802000000         | mov                 eax, dword ptr [ebx]
            //   488d95b0010000       | dec                 eax
            //   488d8d00010000       | mov                 ecx, ebx
            //   e8????????           |                     
            //   488d8d28010000       | dec                 eax
            //   e8????????           |                     
            //   488d0dc0650100       | mov                 edi, esi

    condition:
        7 of them and filesize < 377856
}