rule win_karius_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.karius."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.karius"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41b830000000 488bcf ff15???????? 4885c0 }
            // n = 4, score = 400
            //   41b830000000         | add                 ebx, esi
            //   488bcf               | inc                 ecx
            //   ff15????????         |                     
            //   4885c0               | mov                 ebx, dword ptr [ebx + 0x18]

        $sequence_1 = { 0f84b3000000 458b9f88000000 4d03de 418b5b18 }
            // n = 4, score = 400
            //   0f84b3000000         | dec                 eax
            //   458b9f88000000       | test                eax, eax
            //   4d03de               | jne                 0x14
            //   418b5b18             | mov                 edx, edi

        $sequence_2 = { 41837b1400 0f8492000000 458b4320 458b5324 33ed 4d03c6 4d03d6 }
            // n = 7, score = 400
            //   41837b1400           | inc                 ecx
            //   0f8492000000         | cmp                 dword ptr [ebx + 0x14], 0
            //   458b4320             | je                  0x98
            //   458b5324             | inc                 ebp
            //   33ed                 | mov                 eax, dword ptr [ebx + 0x20]
            //   4d03c6               | inc                 ebp
            //   4d03d6               | mov                 edx, dword ptr [ebx + 0x24]

        $sequence_3 = { 488b05???????? 4885c0 7512 ff15???????? 488905???????? 4885c0 }
            // n = 6, score = 400
            //   488b05????????       |                     
            //   4885c0               | mov                 ebx, dword ptr [ebx + 0x18]
            //   7512                 | test                ebx, ebx
            //   ff15????????         |                     
            //   488905????????       |                     
            //   4885c0               | je                  0xa5

        $sequence_4 = { 498bce ffd3 4183bf8c00000000 0f84b3000000 458b9f88000000 }
            // n = 5, score = 400
            //   498bce               | xor                 ebp, ebp
            //   ffd3                 | dec                 ebp
            //   4183bf8c00000000     | add                 eax, esi
            //   0f84b3000000         | dec                 ebp
            //   458b9f88000000       | add                 edx, esi

        $sequence_5 = { 418b5b18 85db 0f849d000000 41837b1400 }
            // n = 4, score = 400
            //   418b5b18             | dec                 ecx
            //   85db                 | mov                 ecx, esi
            //   0f849d000000         | call                ebx
            //   41837b1400           | inc                 ecx

        $sequence_6 = { 33ed 4d03c6 4d03d6 448bcd 85db 0f8477000000 8bb424b0000000 }
            // n = 7, score = 400
            //   33ed                 | mov                 edx, dword ptr [ebx + 0x24]
            //   4d03c6               | xor                 ebp, ebp
            //   4d03d6               | je                  0xa3
            //   448bcd               | inc                 ecx
            //   85db                 | cmp                 dword ptr [ebx + 0x14], 0
            //   0f8477000000         | je                  0x9d
            //   8bb424b0000000       | inc                 ebp

        $sequence_7 = { 8bb424b0000000 418b10 8bcd 4903d6 0fb602 0f1f440000 c1c90d }
            // n = 7, score = 400
            //   8bb424b0000000       | inc                 ebp
            //   418b10               | mov                 edx, dword ptr [ebx + 0x24]
            //   8bcd                 | mov                 edx, edi
            //   4903d6               | dec                 ecx
            //   0fb602               | mov                 ecx, esi
            //   0f1f440000           | call                ebx
            //   c1c90d               | inc                 ecx

        $sequence_8 = { c3 85c0 7505 e8???????? b801000000 }
            // n = 5, score = 400
            //   c3                   | test                ebx, ebx
            //   85c0                 | je                  0x85
            //   7505                 | mov                 esi, dword ptr [esp + 0xb0]
            //   e8????????           |                     
            //   b801000000           | inc                 ecx

        $sequence_9 = { 8b4dfc 83c704 83c104 83c404 894dfc 8bd0 8955f8 }
            // n = 7, score = 300
            //   8b4dfc               | cmp                 dword ptr [ebx + 0x14], 0
            //   83c704               | je                  0x98
            //   83c104               | inc                 ebp
            //   83c404               | mov                 eax, dword ptr [ebx + 0x20]
            //   894dfc               | inc                 ebp
            //   8bd0                 | mov                 edx, dword ptr [ebx + 0x24]
            //   8955f8               | xor                 ebp, ebp

        $sequence_10 = { a3???????? 85c0 74e2 ff750c 6a08 50 }
            // n = 6, score = 300
            //   a3????????           |                     
            //   85c0                 | je                  0xa9
            //   74e2                 | dec                 ebp
            //   ff750c               | add                 edx, esi
            //   6a08                 | inc                 esp
            //   50                   | mov                 ecx, ebp

        $sequence_11 = { 8bc7 ffc8 7416 ffc8 }
            // n = 4, score = 300
            //   8bc7                 | inc                 ecx
            //   ffc8                 | cmp                 dword ptr [edi + 0x8c], 0
            //   7416                 | je                  0xb9
            //   ffc8                 | inc                 ebp

        $sequence_12 = { 0f93c0 eb06 803900 0f94c0 84c0 }
            // n = 5, score = 300
            //   0f93c0               | je                  0xc8
            //   eb06                 | inc                 ebp
            //   803900               | mov                 ebx, dword ptr [edi + 0x88]
            //   0f94c0               | call                ebx
            //   84c0                 | inc                 ecx

        $sequence_13 = { 488bc8 ff15???????? 4c8be8 498bce }
            // n = 4, score = 300
            //   488bc8               | dec                 ebp
            //   ff15????????         |                     
            //   4c8be8               | add                 ebx, esi
            //   498bce               | inc                 ecx

        $sequence_14 = { 8d7b01 448bfb 448be3 4885c9 }
            // n = 4, score = 300
            //   8d7b01               | mov                 ecx, ebp
            //   448bfb               | test                ebx, ebx
            //   448be3               | je                  0x82
            //   4885c9               | dec                 ecx

        $sequence_15 = { c7400c02000000 c7401401000000 8d4104 5d c3 8a01 3c22 }
            // n = 7, score = 300
            //   c7400c02000000       | test                ebx, ebx
            //   c7401401000000       | je                  0x82
            //   8d4104               | mov                 esi, dword ptr [esp + 0xb0]
            //   5d                   | inc                 ecx
            //   c3                   | mov                 edx, dword ptr [eax]
            //   8a01                 | mov                 ecx, ebp
            //   3c22                 | inc                 ecx

        $sequence_16 = { 488d4b10 488d542450 41b804000000 c6430f68 }
            // n = 4, score = 300
            //   488d4b10             | add                 eax, esi
            //   488d542450           | je                  0xb9
            //   41b804000000         | inc                 ebp
            //   c6430f68             | mov                 ebx, dword ptr [edi + 0x88]

        $sequence_17 = { 7405 f60001 7502 33c0 }
            // n = 4, score = 300
            //   7405                 | mov                 edx, dword ptr [eax]
            //   f60001               | ret                 
            //   7502                 | test                eax, eax
            //   33c0                 | jne                 9

        $sequence_18 = { 4d8bcf 33d2 41b800001000 488bce ff15???????? }
            // n = 5, score = 300
            //   4d8bcf               | mov                 esi, dword ptr [esp + 0xb0]
            //   33d2                 | dec                 ebp
            //   41b800001000         | add                 edx, esi
            //   488bce               | inc                 esp
            //   ff15????????         |                     

        $sequence_19 = { 47 3c2b 7404 3c2d 7501 }
            // n = 5, score = 300
            //   47                   | dec                 ebp
            //   3c2b                 | add                 eax, esi
            //   7404                 | mov                 edi, 1
            //   3c2d                 | mov                 edx, edi
            //   7501                 | dec                 ecx

        $sequence_20 = { 83c40c 85c9 0f8485000000 8a01 }
            // n = 4, score = 300
            //   83c40c               | mov                 ebx, dword ptr [ebx + 0x18]
            //   85c9                 | test                ebx, ebx
            //   0f8485000000         | je                  0xa5
            //   8a01                 | inc                 ecx

        $sequence_21 = { 4d8bcc 4d8bc7 488bd0 488bce ff15???????? 85c0 }
            // n = 6, score = 300
            //   4d8bcc               | test                ebx, ebx
            //   4d8bc7               | je                  0xb3
            //   488bd0               | je                  0x7d
            //   488bce               | mov                 esi, dword ptr [esp + 0xb0]
            //   ff15????????         |                     
            //   85c0                 | inc                 ecx

        $sequence_22 = { 5e 894d0c 5d e9???????? 3c7b 750a 5e }
            // n = 7, score = 300
            //   5e                   | mov                 eax, 1
            //   894d0c               | dec                 ebp
            //   5d                   | add                 ebx, esi
            //   e9????????           |                     
            //   3c7b                 | inc                 ecx
            //   750a                 | mov                 ebx, dword ptr [ebx + 0x18]
            //   5e                   | test                ebx, ebx

        $sequence_23 = { ebc8 8a06 3c41 720c }
            // n = 4, score = 300
            //   ebc8                 | cmp                 dword ptr [edi + 0x8c], 0
            //   8a06                 | je                  0xc1
            //   3c41                 | inc                 ebp
            //   720c                 | mov                 ebx, dword ptr [edi + 0x88]

        $sequence_24 = { 6683f809 7505 8d7b02 eb09 }
            // n = 4, score = 300
            //   6683f809             | dec                 ebp
            //   7505                 | add                 ebx, esi
            //   8d7b02               | inc                 ecx
            //   eb09                 | mov                 ebx, dword ptr [ebx + 0x18]

        $sequence_25 = { 41b900300000 448bc0 33d2 488bce ff15???????? 4c8bf0 }
            // n = 6, score = 300
            //   41b900300000         | movzx               eax, byte ptr [edx]
            //   448bc0               | dec                 ebp
            //   33d2                 | add                 eax, esi
            //   488bce               | dec                 ebp
            //   ff15????????         |                     
            //   4c8bf0               | add                 edx, esi

    condition:
        7 of them and filesize < 434176
}