rule win_kazuar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kazuar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kazuar"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4624 4801db 4c01db 0fb71403 8b461c 498d1493 }
            // n = 6, score = 300
            //   8b4624               | mov                 edx, eax
            //   4801db               | mov                 ebp, esp
            //   4c01db               | test                eax, eax
            //   0fb71403             | je                  0x550
            //   8b461c               | push                ebp
            //   498d1493             | mov                 ebp, esp

        $sequence_1 = { 751c 8b4624 4801db 4c01db 0fb71403 8b461c }
            // n = 6, score = 300
            //   751c                 | test                al, al
            //   8b4624               | je                  0x29b
            //   4801db               | movsx               eax, al
            //   4c01db               | xor                 esi, eax
            //   0fb71403             | inc                 esp
            //   8b461c               | mov                 eax, eax

        $sequence_2 = { 4489c8 410fbe0c02 84c9 7417 e8???????? }
            // n = 5, score = 300
            //   4489c8               | dec                 eax
            //   410fbe0c02           | mov                 ecx, eax
            //   84c9                 | xor                 eax, eax
            //   7417                 | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { 53 4881ec30010000 31c9 41b804010000 }
            // n = 4, score = 300
            //   53                   | dec                 eax
            //   4881ec30010000       | mov                 edx, ebp
            //   31c9                 | dec                 ecx
            //   41b804010000         | mov                 ecx, edi

        $sequence_4 = { eb07 48ffc3 ebc8 31c0 4883c420 5b 5e }
            // n = 7, score = 300
            //   eb07                 | sete                al
            //   48ffc3               | dec                 eax
            //   ebc8                 | add                 esp, 0x130
            //   31c0                 | jne                 0x247
            //   4883c420             | xor                 eax, eax
            //   5b                   | jmp                 0x26a
            //   5e                   | dec                 eax

        $sequence_5 = { 4883ec28 e8???????? ba44a73378 4889c1 }
            // n = 4, score = 300
            //   4883ec28             | add                 ebp, ebx
            //   e8????????           |                     
            //   ba44a73378           | inc                 ecx
            //   4889c1               | cmp                 esp, ebx

        $sequence_6 = { 31c9 41b804010000 488d5c242c 4889da ff15???????? }
            // n = 5, score = 300
            //   31c9                 | mov                 eax, dword ptr [ecx]
            //   41b804010000         | mov                 eax, dword ptr [eax + 0xc]
            //   488d5c242c           | mov                 dword ptr [ebp - 0x2c], eax
            //   4889da               | mov                 dword ptr [ebp - 0x1c], 0
            //   ff15????????         |                     

        $sequence_7 = { 7428 4989db 498b4b40 e8???????? }
            // n = 4, score = 300
            //   7428                 | mov                 dword ptr [esp + 0x29], 0x3e3a3a1d
            //   4989db               | xor                 eax, eax
            //   498b4b40             | mov                 word ptr [esp + 0x2d], 0x2d10
            //   e8????????           |                     

        $sequence_8 = { 31c9 41b804010000 488d5c242c 4889da }
            // n = 4, score = 300
            //   31c9                 | dec                 ebp
            //   41b804010000         | test                edx, edx
            //   488d5c242c           | je                  0x4c
            //   4889da               | dec                 eax

        $sequence_9 = { 4889c1 4989c0 e8???????? 4c8d4c2428 31d2 31c9 01c0 }
            // n = 7, score = 300
            //   4889c1               | mov                 dword ptr [esp + 0xc], eax
            //   4989c0               | lea                 eax, [ebp - 0x10]
            //   e8????????           |                     
            //   4c8d4c2428           | mov                 dword ptr [esp + 8], eax
            //   31d2                 | call                ecx
            //   31c9                 | lea                 eax, [ebp - 0x10]
            //   01c0                 | mov                 dword ptr [esp + 8], eax

    condition:
        7 of them and filesize < 81920
}