rule win_killdisk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.killdisk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.killdisk"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bf3 8bd6 741c 2bee 57 8bff }
            // n = 6, score = 100
            //   3bf3                 | cmp                 esi, ebx
            //   8bd6                 | mov                 edx, esi
            //   741c                 | je                  0x1e
            //   2bee                 | sub                 ebp, esi
            //   57                   | push                edi
            //   8bff                 | mov                 edi, edi

        $sequence_1 = { 881438 e8???????? 9c c6442408cf }
            // n = 4, score = 100
            //   881438               | mov                 byte ptr [eax + edi], dl
            //   e8????????           |                     
            //   9c                   | pushfd              
            //   c6442408cf           | mov                 byte ptr [esp + 8], 0xcf

        $sequence_2 = { 0f89bc010000 60 9c 8f44241c c64424148e c644240426 e8???????? }
            // n = 7, score = 100
            //   0f89bc010000         | jns                 0x1c2
            //   60                   | pushal              
            //   9c                   | pushfd              
            //   8f44241c             | pop                 dword ptr [esp + 0x1c]
            //   c64424148e           | mov                 byte ptr [esp + 0x14], 0x8e
            //   c644240426           | mov                 byte ptr [esp + 4], 0x26
            //   e8????????           |                     

        $sequence_3 = { e8???????? 9c 8f442420 ff3424 ff742424 8f4500 9c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   9c                   | pushfd              
            //   8f442420             | pop                 dword ptr [esp + 0x20]
            //   ff3424               | push                dword ptr [esp]
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   8f4500               | pop                 dword ptr [ebp]
            //   9c                   | pushfd              

        $sequence_4 = { 8b8c24d41a0000 5f 5e 5b }
            // n = 4, score = 100
            //   8b8c24d41a0000       | mov                 ecx, dword ptr [esp + 0x1ad4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_5 = { 83c10f 836c242001 894c2410 0f85f8feffff 8b6c2428 }
            // n = 5, score = 100
            //   83c10f               | add                 ecx, 0xf
            //   836c242001           | sub                 dword ptr [esp + 0x20], 1
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   0f85f8feffff         | jne                 0xfffffefe
            //   8b6c2428             | mov                 ebp, dword ptr [esp + 0x28]

        $sequence_6 = { 8be5 5d c20400 8b4804 8b30 }
            // n = 5, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8b30                 | mov                 esi, dword ptr [eax]

        $sequence_7 = { ff15???????? 3c05 0f85f8010000 b9???????? e8???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   3c05                 | cmp                 al, 5
            //   0f85f8010000         | jne                 0x1fe
            //   b9????????           |                     
            //   e8????????           |                     

        $sequence_8 = { e9???????? ff742404 66894500 886c2408 9c }
            // n = 5, score = 100
            //   e9????????           |                     
            //   ff742404             | push                dword ptr [esp + 4]
            //   66894500             | mov                 word ptr [ebp], ax
            //   886c2408             | mov                 byte ptr [esp + 8], ch
            //   9c                   | pushfd              

        $sequence_9 = { 50 51 e8???????? 4e 80fcd7 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   4e                   | dec                 esi
            //   80fcd7               | cmp                 ah, 0xd7

        $sequence_10 = { ff15???????? e9???????? 83f810 0f8461ffffff 3d01010000 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   e9????????           |                     
            //   83f810               | cmp                 eax, 0x10
            //   0f8461ffffff         | je                  0xffffff67
            //   3d01010000           | cmp                 eax, 0x101

        $sequence_11 = { 5e e8???????? 66ffc6 e8???????? }
            // n = 4, score = 100
            //   5e                   | pop                 esi
            //   e8????????           |                     
            //   66ffc6               | inc                 si
            //   e8????????           |                     

        $sequence_12 = { 50 8d642434 e9???????? 660fbcc3 660fa5e0 8b4500 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d642434             | lea                 esp, [esp + 0x34]
            //   e9????????           |                     
            //   660fbcc3             | bsf                 ax, bx
            //   660fa5e0             | shld                ax, sp, cl
            //   8b4500               | mov                 eax, dword ptr [ebp]

        $sequence_13 = { c604243a 9c 8d642434 e9???????? 883424 }
            // n = 5, score = 100
            //   c604243a             | mov                 byte ptr [esp], 0x3a
            //   9c                   | pushfd              
            //   8d642434             | lea                 esp, [esp + 0x34]
            //   e9????????           |                     
            //   883424               | mov                 byte ptr [esp], dh

        $sequence_14 = { 85f6 74f6 8bfe e8???????? 8b4314 }
            // n = 5, score = 100
            //   85f6                 | test                esi, esi
            //   74f6                 | je                  0xfffffff8
            //   8bfe                 | mov                 edi, esi
            //   e8????????           |                     
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]

        $sequence_15 = { 33c0 89442404 89442408 8944240c 8d442408 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8d442408             | lea                 eax, [esp + 8]

    condition:
        7 of them and filesize < 10817536
}