rule win_kingminer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kingminer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kingminer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a00 57 ff15???????? 6a00 57 ff15???????? }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_1 = { 752d 83791000 7514 8b4f3c 8b17 394a38 740a }
            // n = 7, score = 100
            //   752d                 | jne                 0x2f
            //   83791000             | cmp                 dword ptr [ecx + 0x10], 0
            //   7514                 | jne                 0x16
            //   8b4f3c               | mov                 ecx, dword ptr [edi + 0x3c]
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   394a38               | cmp                 dword ptr [edx + 0x38], ecx
            //   740a                 | je                  0xc

        $sequence_2 = { d1e9 83c002 3bd1 72d1 }
            // n = 4, score = 100
            //   d1e9                 | shr                 ecx, 1
            //   83c002               | add                 eax, 2
            //   3bd1                 | cmp                 edx, ecx
            //   72d1                 | jb                  0xffffffd3

        $sequence_3 = { 6a00 52 ff15???????? 6a00 ff15???????? a1???????? }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   52                   | push                edx
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   a1????????           |                     

        $sequence_4 = { 7524 a1???????? a3???????? a1???????? c705????????6d7b0010 }
            // n = 5, score = 100
            //   7524                 | jne                 0x26
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????6d7b0010     |     

        $sequence_5 = { 7406 33c0 5d c21000 e8???????? }
            // n = 5, score = 100
            //   7406                 | je                  8
            //   33c0                 | xor                 eax, eax
            //   5d                   | pop                 ebp
            //   c21000               | ret                 0x10
            //   e8????????           |                     

        $sequence_6 = { 8b4704 8b15???????? 8945fc 8b07 }
            // n = 4, score = 100
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   8b15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_7 = { f3a5 ff249590640010 8bc7 ba03000000 83e904 }
            // n = 5, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff249590640010       | jmp                 dword ptr [edx*4 + 0x10006490]
            //   8bc7                 | mov                 eax, edi
            //   ba03000000           | mov                 edx, 3
            //   83e904               | sub                 ecx, 4

        $sequence_8 = { 50 ff15???????? 3bc7 7435 8d8de8feffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3bc7                 | cmp                 eax, edi
            //   7435                 | je                  0x37
            //   8d8de8feffff         | lea                 ecx, [ebp - 0x118]

        $sequence_9 = { 8b95d0feffff 2b4234 7419 83b9a000000000 7466 50 }
            // n = 6, score = 100
            //   8b95d0feffff         | mov                 edx, dword ptr [ebp - 0x130]
            //   2b4234               | sub                 eax, dword ptr [edx + 0x34]
            //   7419                 | je                  0x1b
            //   83b9a000000000       | cmp                 dword ptr [ecx + 0xa0], 0
            //   7466                 | je                  0x68
            //   50                   | push                eax

    condition:
        7 of them and filesize < 165888
}