rule win_korlia_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.korlia."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.korlia"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81fb68584d56 0f9445e4 5b 59 5a c745fcffffffff 8a45e4 }
            // n = 7, score = 2300
            //   81fb68584d56         | cmp                 ebx, 0x564d5868
            //   0f9445e4             | sete                byte ptr [ebp - 0x1c]
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx
            //   5a                   | pop                 edx
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8a45e4               | mov                 al, byte ptr [ebp - 0x1c]

        $sequence_1 = { c1fa0e 8bc2 c1e81f 03d0 52 68???????? 51 }
            // n = 7, score = 2300
            //   c1fa0e               | sar                 edx, 0xe
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03d0                 | add                 edx, eax
            //   52                   | push                edx
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_2 = { 68???????? 51 ffd6 8bc7 b980ee3600 99 }
            // n = 6, score = 2300
            //   68????????           |                     
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8bc7                 | mov                 eax, edi
            //   b980ee3600           | mov                 ecx, 0x36ee80
            //   99                   | cdq                 

        $sequence_3 = { 8bc7 b9005c2605 99 f7f9 }
            // n = 4, score = 2300
            //   8bc7                 | mov                 eax, edi
            //   b9005c2605           | mov                 ecx, 0x5265c00
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx

        $sequence_4 = { ff15???????? 8bf8 b83bd4b531 f7ef }
            // n = 4, score = 2300
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   b83bd4b531           | mov                 eax, 0x31b5d43b
            //   f7ef                 | imul                edi

        $sequence_5 = { 68???????? 68???????? ffd6 b905000000 be???????? }
            // n = 5, score = 2300
            //   68????????           |                     
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   b905000000           | mov                 ecx, 5
            //   be????????           |                     

        $sequence_6 = { c3 85db 7410 6a28 68???????? 6aff }
            // n = 6, score = 2300
            //   c3                   | ret                 
            //   85db                 | test                ebx, ebx
            //   7410                 | je                  0x12
            //   6a28                 | push                0x28
            //   68????????           |                     
            //   6aff                 | push                -1

        $sequence_7 = { 83ec0c 53 56 57 8965e8 c645e401 c745fc00000000 }
            // n = 7, score = 2300
            //   83ec0c               | sub                 esp, 0xc
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   c645e401             | mov                 byte ptr [ebp - 0x1c], 1
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_8 = { 6a01 53 53 53 51 ff15???????? 85c0 }
            // n = 7, score = 2000
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_9 = { 8b442404 56 6a00 6a00 6a01 6a00 6a00 }
            // n = 7, score = 700
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   56                   | push                esi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_10 = { 6a01 6a00 6a00 6800000040 50 ff15???????? 8bf0 }
            // n = 7, score = 700
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800000040           | push                0x40000000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_11 = { 8bf0 83feff 7423 8b542410 8b44240c 8d4c2408 6a00 }
            // n = 7, score = 600
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   7423                 | je                  0x25
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   6a00                 | push                0

        $sequence_12 = { e8???????? 8a4c2404 6a01 884814 }
            // n = 4, score = 600
            //   e8????????           |                     
            //   8a4c2404             | mov                 cl, byte ptr [esp + 4]
            //   6a01                 | push                1
            //   884814               | mov                 byte ptr [eax + 0x14], cl

        $sequence_13 = { 59 59 c3 8b65e8 ff7588 ff15???????? 833d????????ff }
            // n = 7, score = 600
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   8b65e8               | mov                 esp, dword ptr [ebp - 0x18]
            //   ff7588               | push                dword ptr [ebp - 0x78]
            //   ff15????????         |                     
            //   833d????????ff       |                     

        $sequence_14 = { 898840200000 58 c20800 e9???????? 6800060000 6a00 e8???????? }
            // n = 7, score = 600
            //   898840200000         | mov                 dword ptr [eax + 0x2040], ecx
            //   58                   | pop                 eax
            //   c20800               | ret                 8
            //   e9????????           |                     
            //   6800060000           | push                0x600
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_15 = { ff7588 ff15???????? 833d????????ff 750c ff742404 ff15???????? 59 }
            // n = 7, score = 600
            //   ff7588               | push                dword ptr [ebp - 0x78]
            //   ff15????????         |                     
            //   833d????????ff       |                     
            //   750c                 | jne                 0xe
            //   ff742404             | push                dword ptr [esp + 4]
            //   ff15????????         |                     
            //   59                   | pop                 ecx

        $sequence_16 = { 50 56 ff15???????? 56 ff15???????? b001 }
            // n = 6, score = 600
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   b001                 | mov                 al, 1

        $sequence_17 = { ff742410 ff742410 ff742410 e8???????? c21000 e8???????? 8a4c2404 }
            // n = 7, score = 600
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   e8????????           |                     
            //   c21000               | ret                 0x10
            //   e8????????           |                     
            //   8a4c2404             | mov                 cl, byte ptr [esp + 4]

        $sequence_18 = { 8bf9 81e7ff000000 03f2 03f7 }
            // n = 4, score = 500
            //   8bf9                 | mov                 edi, ecx
            //   81e7ff000000         | and                 edi, 0xff
            //   03f2                 | add                 esi, edx
            //   03f7                 | add                 esi, edi

        $sequence_19 = { 8d442444 894d00 8b542438 83c504 }
            // n = 4, score = 500
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   894d00               | mov                 dword ptr [ebp], ecx
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]
            //   83c504               | add                 ebp, 4

        $sequence_20 = { 680030c800 6a00 6a00 68???????? }
            // n = 4, score = 500
            //   680030c800           | push                0xc83000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_21 = { 8b542438 83c504 50 895500 }
            // n = 4, score = 500
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]
            //   83c504               | add                 ebp, 4
            //   50                   | push                eax
            //   895500               | mov                 dword ptr [ebp], edx

        $sequence_22 = { b8447c0000 e8???????? 53 56 }
            // n = 4, score = 500
            //   b8447c0000           | mov                 eax, 0x7c44
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_23 = { 6a00 6880000000 6800000400 8bce }
            // n = 4, score = 500
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6800000400           | push                0x40000
            //   8bce                 | mov                 ecx, esi

        $sequence_24 = { 6a00 6a00 6a00 50 8bce e8???????? 6a00 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_25 = { 51 ff15???????? a1???????? b981000000 }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   a1????????           |                     
            //   b981000000           | mov                 ecx, 0x81

        $sequence_26 = { 85c0 750c ff15???????? 53 e9???????? }
            // n = 5, score = 400
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   e9????????           |                     

        $sequence_27 = { ffd6 8d44240c 6804010000 50 }
            // n = 4, score = 400
            //   ffd6                 | call                esi
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   6804010000           | push                0x104
            //   50                   | push                eax

        $sequence_28 = { 50 ffd6 eb06 8b35???????? a1???????? }
            // n = 5, score = 300
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   eb06                 | jmp                 8
            //   8b35????????         |                     
            //   a1????????           |                     

        $sequence_29 = { 68ff0f1f00 ff15???????? 85c0 740a }
            // n = 4, score = 300
            //   68ff0f1f00           | push                0x1f0fff
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc

        $sequence_30 = { e8???????? 6a00 6a00 8d542414 6a00 52 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   6a00                 | push                0
            //   52                   | push                edx

        $sequence_31 = { 7403 50 ffd6 b912010000 33c0 }
            // n = 5, score = 300
            //   7403                 | je                  5
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   b912010000           | mov                 ecx, 0x112
            //   33c0                 | xor                 eax, eax

        $sequence_32 = { 8d4c2410 6804010000 51 aa ff15???????? bf???????? 83c9ff }
            // n = 7, score = 300
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   6804010000           | push                0x104
            //   51                   | push                ecx
            //   aa                   | stosb               byte ptr es:[edi], al
            //   ff15????????         |                     
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_33 = { 6a00 68???????? 6801000080 ff15???????? 85c0 0f8599000000 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8599000000         | jne                 0x9f

        $sequence_34 = { 8d442400 50 6806000200 6a00 }
            // n = 4, score = 300
            //   8d442400             | lea                 eax, [esp]
            //   50                   | push                eax
            //   6806000200           | push                0x20006
            //   6a00                 | push                0

        $sequence_35 = { 85c0 740a 56 50 ff15???????? 8bf0 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_36 = { 8b4c2410 50 6a01 6a00 68???????? 51 }
            // n = 6, score = 300
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_37 = { 3bc3 57 740b 8b35???????? 50 }
            // n = 5, score = 300
            //   3bc3                 | cmp                 eax, ebx
            //   57                   | push                edi
            //   740b                 | je                  0xd
            //   8b35????????         |                     
            //   50                   | push                eax

        $sequence_38 = { 8b35???????? a1???????? 3bc3 7403 50 }
            // n = 5, score = 300
            //   8b35????????         |                     
            //   a1????????           |                     
            //   3bc3                 | cmp                 eax, ebx
            //   7403                 | je                  5
            //   50                   | push                eax

        $sequence_39 = { 8d7c2411 88442410 f3ab 66ab 8d4c2410 6804010000 }
            // n = 6, score = 300
            //   8d7c2411             | lea                 edi, [esp + 0x11]
            //   88442410             | mov                 byte ptr [esp + 0x10], al
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   6804010000           | push                0x104

        $sequence_40 = { 33c0 8dbc245e020000 66899c245c020000 f3ab }
            // n = 4, score = 300
            //   33c0                 | xor                 eax, eax
            //   8dbc245e020000       | lea                 edi, [esp + 0x25e]
            //   66899c245c020000     | mov                 word ptr [esp + 0x25c], bx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_41 = { 68003e0000 f2ae f7d1 2bf9 68???????? }
            // n = 5, score = 100
            //   68003e0000           | push                0x3e00
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   68????????           |                     

        $sequence_42 = { e8???????? 83c414 8d8424e0050000 50 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8d8424e0050000       | lea                 eax, [esp + 0x5e0]
            //   50                   | push                eax

        $sequence_43 = { 8d85f4edffff 6a08 ffb5f0edffff 50 e8???????? }
            // n = 5, score = 100
            //   8d85f4edffff         | lea                 eax, [ebp - 0x120c]
            //   6a08                 | push                8
            //   ffb5f0edffff         | push                dword ptr [ebp - 0x1210]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_44 = { 56 57 b97c000000 33c0 8dbdd1fbffff c685d0fbffff00 8965f0 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   b97c000000           | mov                 ecx, 0x7c
            //   33c0                 | xor                 eax, eax
            //   8dbdd1fbffff         | lea                 edi, [ebp - 0x42f]
            //   c685d0fbffff00       | mov                 byte ptr [ebp - 0x430], 0
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp

        $sequence_45 = { 55 8b2d???????? 56 57 33db b90c000000 33c0 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8b2d????????         |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   b90c000000           | mov                 ecx, 0xc
            //   33c0                 | xor                 eax, eax

        $sequence_46 = { 68???????? 52 c745cc0c714000 e8???????? 8d45c8 8d8dc4fdffff 50 }
            // n = 7, score = 100
            //   68????????           |                     
            //   52                   | push                edx
            //   c745cc0c714000       | mov                 dword ptr [ebp - 0x34], 0x40710c
            //   e8????????           |                     
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   8d8dc4fdffff         | lea                 ecx, [ebp - 0x23c]
            //   50                   | push                eax

        $sequence_47 = { e9???????? e8???????? 99 b970170000 f7f9 81c2983a0000 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b970170000           | mov                 ecx, 0x1770
            //   f7f9                 | idiv                ecx
            //   81c2983a0000         | add                 edx, 0x3a98

        $sequence_48 = { 8db5d4f2ffff 8dbdc8f0ffff 6a00 f3a5 50 }
            // n = 5, score = 100
            //   8db5d4f2ffff         | lea                 esi, [ebp - 0xd2c]
            //   8dbdc8f0ffff         | lea                 edi, [ebp - 0xf38]
            //   6a00                 | push                0
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   50                   | push                eax

        $sequence_49 = { 899c2458040000 e8???????? 8d8c24582c0000 50 51 e8???????? }
            // n = 6, score = 100
            //   899c2458040000       | mov                 dword ptr [esp + 0x458], ebx
            //   e8????????           |                     
            //   8d8c24582c0000       | lea                 ecx, [esp + 0x2c58]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_50 = { 8d4dfc 0345fc 51 8b4df4 51 }
            // n = 5, score = 100
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   51                   | push                ecx

        $sequence_51 = { 8d4510 6a04 50 8b4608 6a1f 53 ffd0 }
            // n = 7, score = 100
            //   8d4510               | lea                 eax, [ebp + 0x10]
            //   6a04                 | push                4
            //   50                   | push                eax
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   6a1f                 | push                0x1f
            //   53                   | push                ebx
            //   ffd0                 | call                eax

    condition:
        7 of them and filesize < 263168
}