rule win_kuluoz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kuluoz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kuluoz"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0355ec 8955f8 8b45fc 0345ec }
            // n = 4, score = 100
            //   0355ec               | add                 edx, dword ptr [ebp - 0x14]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0345ec               | add                 eax, dword ptr [ebp - 0x14]

        $sequence_1 = { 8b45f0 50 e8???????? 8945f4 837df4ff 7405 8b45f4 }
            // n = 7, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   837df4ff             | cmp                 dword ptr [ebp - 0xc], -1
            //   7405                 | je                  7
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_2 = { 68???????? 8d4df4 51 e8???????? 0fb6d0 85d2 740f }
            // n = 7, score = 100
            //   68????????           |                     
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   0fb6d0               | movzx               edx, al
            //   85d2                 | test                edx, edx
            //   740f                 | je                  0x11

        $sequence_3 = { 2b45fc 894510 8b4d0c 034dfc }
            // n = 4, score = 100
            //   2b45fc               | sub                 eax, dword ptr [ebp - 4]
            //   894510               | mov                 dword ptr [ebp + 0x10], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   034dfc               | add                 ecx, dword ptr [ebp - 4]

        $sequence_4 = { 8d45fc 50 6a00 6a00 68???????? ff15???????? 8b45fc }
            // n = 7, score = 100
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { 83c202 52 ff15???????? 8945ec 837dec00 740f 8b45ec }
            // n = 7, score = 100
            //   83c202               | add                 edx, 2
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   740f                 | je                  0x11
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_6 = { 8b55f0 0fb602 50 e8???????? 8945fc }
            // n = 5, score = 100
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   0fb602               | movzx               eax, byte ptr [edx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_7 = { 8b4d10 8b91fe010000 8b4510 8b4df4 8a09 }
            // n = 5, score = 100
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b91fe010000         | mov                 edx, dword ptr [ecx + 0x1fe]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8a09                 | mov                 cl, byte ptr [ecx]

        $sequence_8 = { 894594 8b4d8c 894df4 8b5590 8955f8 8b4594 }
            // n = 6, score = 100
            //   894594               | mov                 dword ptr [ebp - 0x6c], eax
            //   8b4d8c               | mov                 ecx, dword ptr [ebp - 0x74]
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8b5590               | mov                 edx, dword ptr [ebp - 0x70]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b4594               | mov                 eax, dword ptr [ebp - 0x6c]

        $sequence_9 = { b900100000 f7f1 8b45fc 2bc2 }
            // n = 4, score = 100
            //   b900100000           | mov                 ecx, 0x1000
            //   f7f1                 | div                 ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   2bc2                 | sub                 eax, edx

    condition:
        7 of them and filesize < 65536
}