rule win_lazardoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lazardoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lazardoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7516 488d05530e0100 4a8b04e8 42385cf839 }
            // n = 4, score = 200
            //   7516                 | mov                 edx, 0x5451
            //   488d05530e0100       | dec                 eax
            //   4a8b04e8             | lea                 ecx, [0x1aaa8]
            //   42385cf839           | jmp                 0xcf3

        $sequence_1 = { 488bc8 e8???????? e8???????? 448bc0 c705????????62716365 b867666666 }
            // n = 6, score = 200
            //   488bc8               | mov                 eax, dword ptr [eax - 4]
            //   e8????????           |                     
            //   e8????????           |                     
            //   448bc0               | shr                 eax, cl
            //   c705????????62716365     |     
            //   b867666666           | cmp                 dword ptr [edx + 8], 0

        $sequence_2 = { 0fb60a 83e10f 4a0fbe841188a50100 428a8c1198a50100 482bd0 8b42fc }
            // n = 6, score = 200
            //   0fb60a               | mov                 cl, byte ptr [ecx + ebx + 0x1a598]
            //   83e10f               | dec                 esp
            //   4a0fbe841188a50100     | sub    ecx, eax
            //   428a8c1198a50100     | inc                 ecx
            //   482bd0               | mov                 eax, dword ptr [ecx - 4]
            //   8b42fc               | and                 ecx, 0xf

        $sequence_3 = { 410fb609 83e10f 4a0fbe843188a50100 428a8c3198a50100 4c2bc8 }
            // n = 5, score = 200
            //   410fb609             | lea                 ecx, [esi + 0x828]
            //   83e10f               | sub                 ebx, edi
            //   4a0fbe843188a50100     | inc    ecx
            //   428a8c3198a50100     | cmp                 ebx, esp
            //   4c2bc8               | inc                 ecx

        $sequence_4 = { 03d0 8d0492 2bc8 890d???????? 83fb05 0f82f5feffff ba5b540000 }
            // n = 7, score = 200
            //   03d0                 | test                ebx, ebx
            //   8d0492               | je                  0x573
            //   2bc8                 | nop                 
            //   890d????????         |                     
            //   83fb05               | sub                 ebx, esi
            //   0f82f5feffff         | dec                 esp
            //   ba5b540000           | mov                 dword ptr [esp + 0x70], esi

        $sequence_5 = { 448d4304 488bce 488d542440 ff15???????? }
            // n = 4, score = 200
            //   448d4304             | inc                 ecx
            //   488bce               | mov                 eax, esi
            //   488d542440           | dec                 eax
            //   ff15????????         |                     

        $sequence_6 = { 0f8531040000 4863693c 4803e9 817d0050450000 0f851d040000 8b5550 41b904000000 }
            // n = 7, score = 200
            //   0f8531040000         | lea                 ecx, [edx + eax]
            //   4863693c             | dec                 ecx
            //   4803e9               | mov                 dword ptr [eax + 0x30], ecx
            //   817d0050450000       | inc                 ecx
            //   0f851d040000         | movzx               ecx, byte ptr [ecx]
            //   8b5550               | and                 ecx, 0xf
            //   41b904000000         | dec                 edx

        $sequence_7 = { e9???????? 41b880140000 488d1595560200 488d4c2440 e8???????? }
            // n = 5, score = 200
            //   e9????????           |                     
            //   41b880140000         | dec                 esp
            //   488d1595560200       | lea                 edi, [0x14960]
            //   488d4c2440           | inc                 ecx
            //   e8????????           |                     

        $sequence_8 = { 410fb6d3 4c8d0db3c90000 83f201 03d2 8bc2 }
            // n = 5, score = 200
            //   410fb6d3             | dec                 ecx
            //   4c8d0db3c90000       | mov                 ecx, edi
            //   83f201               | dec                 ebp
            //   03d2                 | mov                 eax, esi
            //   8bc2                 | dec                 eax

        $sequence_9 = { 8b1d???????? 41bcffff0000 85db 7440 }
            // n = 4, score = 200
            //   8b1d????????         |                     
            //   41bcffff0000         | je                  0x17ba
            //   85db                 | dec                 eax
            //   7440                 | lea                 edx, [esp + 0x50]

    condition:
        7 of them and filesize < 405504
}