rule win_laziok_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.laziok."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.laziok"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 39742410 741b ff742410 ff15???????? 8bf0 85f6 }
            // n = 6, score = 900
            //   39742410             | cmp                 dword ptr [esp + 0x10], esi
            //   741b                 | je                  0x1d
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_1 = { 59 85f6 7410 46 }
            // n = 4, score = 900
            //   59                   | pop                 ecx
            //   85f6                 | test                esi, esi
            //   7410                 | je                  0x12
            //   46                   | inc                 esi

        $sequence_2 = { ff750c ff7608 ff15???????? eb3f 6a02 58 }
            // n = 6, score = 900
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff15????????         |                     
            //   eb3f                 | jmp                 0x41
            //   6a02                 | push                2
            //   58                   | pop                 eax

        $sequence_3 = { 837c240cff 8937 7502 8bf7 5f 8bc6 }
            // n = 6, score = 900
            //   837c240cff           | cmp                 dword ptr [esp + 0xc], -1
            //   8937                 | mov                 dword ptr [edi], esi
            //   7502                 | jne                 4
            //   8bf7                 | mov                 esi, edi
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_4 = { 833e01 7513 6a00 ff7510 ff750c }
            // n = 5, score = 900
            //   833e01               | cmp                 dword ptr [esi], 1
            //   7513                 | jne                 0x15
            //   6a00                 | push                0
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { 2bc6 d1f8 83f801 7d03 }
            // n = 4, score = 900
            //   2bc6                 | sub                 eax, esi
            //   d1f8                 | sar                 eax, 1
            //   83f801               | cmp                 eax, 1
            //   7d03                 | jge                 5

        $sequence_6 = { 2bc6 d1f8 83f901 7d07 }
            // n = 4, score = 900
            //   2bc6                 | sub                 eax, esi
            //   d1f8                 | sar                 eax, 1
            //   83f901               | cmp                 ecx, 1
            //   7d07                 | jge                 9

        $sequence_7 = { 7404 8b00 eb03 8b4610 }
            // n = 4, score = 900
            //   7404                 | je                  6
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   eb03                 | jmp                 5
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]

    condition:
        7 of them and filesize < 688128
}