rule win_ldr4_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ldr4."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ldr4"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7407 50 ff15???????? 53 55 57 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   50                   | push                eax
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   57                   | push                edi

        $sequence_1 = { e8???????? 8bfb 85db 0f855d020000 8d44242c 50 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bfb                 | mov                 edi, ebx
            //   85db                 | test                ebx, ebx
            //   0f855d020000         | jne                 0x263
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 8b7368 57 85f6 7437 83c350 }
            // n = 5, score = 100
            //   8b7368               | mov                 esi, dword ptr [ebx + 0x68]
            //   57                   | push                edi
            //   85f6                 | test                esi, esi
            //   7437                 | je                  0x39
            //   83c350               | add                 ebx, 0x50

        $sequence_3 = { a1???????? 8b4008 53 56 8b35???????? 57 6a11 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   57                   | push                edi
            //   6a11                 | push                0x11

        $sequence_4 = { 57 33c0 e8???????? 894508 83c324 83c8ff f00fc103 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   e8????????           |                     
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   83c324               | add                 ebx, 0x24
            //   83c8ff               | or                  eax, 0xffffffff
            //   f00fc103             | lock xadd           dword ptr [ebx], eax

        $sequence_5 = { 83c40c ff75f4 ffd3 8b4674 3945fc 7203 8945fc }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ffd3                 | call                ebx
            //   8b4674               | mov                 eax, dword ptr [esi + 0x74]
            //   3945fc               | cmp                 dword ptr [ebp - 4], eax
            //   7203                 | jb                  5
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { 0bf2 687caaf6db 8b450c 8b4810 e8???????? 85c0 }
            // n = 6, score = 100
            //   0bf2                 | or                  esi, edx
            //   687caaf6db           | push                0xdbf6aa7c
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4810               | mov                 ecx, dword ptr [eax + 0x10]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 683799f0e7 c74514a00a0000 e8???????? 3bc7 740d 6a04 8d4d14 }
            // n = 7, score = 100
            //   683799f0e7           | push                0xe7f09937
            //   c74514a00a0000       | mov                 dword ptr [ebp + 0x14], 0xaa0
            //   e8????????           |                     
            //   3bc7                 | cmp                 eax, edi
            //   740d                 | je                  0xf
            //   6a04                 | push                4
            //   8d4d14               | lea                 ecx, [ebp + 0x14]

        $sequence_8 = { 57 8bce e8???????? 85c0 750a 8b4e28 8b5510 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   8b4e28               | mov                 ecx, dword ptr [esi + 0x28]
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_9 = { 50 ff75f8 e8???????? ff75f8 894508 6a00 56 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   6a00                 | push                0
            //   56                   | push                esi

    condition:
        7 of them and filesize < 117760
}