rule win_lechiket_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lechiket."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lechiket"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff45fc 817dfce8030000 0f8222ffffff 53 56 }
            // n = 5, score = 100
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   817dfce8030000       | cmp                 dword ptr [ebp - 4], 0x3e8
            //   0f8222ffffff         | jb                  0xffffff28
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_1 = { 6800400000 8d4de8 8945fc e8???????? }
            // n = 4, score = 100
            //   6800400000           | push                0x4000
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     

        $sequence_2 = { 68???????? c685fcfeffff00 e8???????? 8d85fcfeffff 50 8d45fc 50 }
            // n = 7, score = 100
            //   68????????           |                     
            //   c685fcfeffff00       | mov                 byte ptr [ebp - 0x104], 0
            //   e8????????           |                     
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_3 = { 7c77 3c39 7f73 33c9 3c39 7f16 }
            // n = 6, score = 100
            //   7c77                 | jl                  0x79
            //   3c39                 | cmp                 al, 0x39
            //   7f73                 | jg                  0x75
            //   33c9                 | xor                 ecx, ecx
            //   3c39                 | cmp                 al, 0x39
            //   7f16                 | jg                  0x18

        $sequence_4 = { 6a03 57 8b7d08 6880000000 56 8d45e8 }
            // n = 6, score = 100
            //   6a03                 | push                3
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   6880000000           | push                0x80
            //   56                   | push                esi
            //   8d45e8               | lea                 eax, [ebp - 0x18]

        $sequence_5 = { c645af54 c645b068 c645b172 c645b265 c645b361 }
            // n = 5, score = 100
            //   c645af54             | mov                 byte ptr [ebp - 0x51], 0x54
            //   c645b068             | mov                 byte ptr [ebp - 0x50], 0x68
            //   c645b172             | mov                 byte ptr [ebp - 0x4f], 0x72
            //   c645b265             | mov                 byte ptr [ebp - 0x4e], 0x65
            //   c645b361             | mov                 byte ptr [ebp - 0x4d], 0x61

        $sequence_6 = { 7596 eb07 c7450c010000c0 8b4508 ff7008 ff15???????? }
            // n = 6, score = 100
            //   7596                 | jne                 0xffffff98
            //   eb07                 | jmp                 9
            //   c7450c010000c0       | mov                 dword ptr [ebp + 0xc], 0xc0000001
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff7008               | push                dword ptr [eax + 8]
            //   ff15????????         |                     

        $sequence_7 = { ff15???????? 8d45f8 50 8d45e8 50 56 53 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   56                   | push                esi
            //   53                   | push                ebx

        $sequence_8 = { 83e103 f3a4 8b4218 83f8ff 7428 }
            // n = 5, score = 100
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8b4218               | mov                 eax, dword ptr [edx + 0x18]
            //   83f8ff               | cmp                 eax, -1
            //   7428                 | je                  0x2a

        $sequence_9 = { ff34bd68830100 e8???????? a1???????? 47 83c504 3bf8 72bb }
            // n = 7, score = 100
            //   ff34bd68830100       | push                dword ptr [edi*4 + 0x18368]
            //   e8????????           |                     
            //   a1????????           |                     
            //   47                   | inc                 edi
            //   83c504               | add                 ebp, 4
            //   3bf8                 | cmp                 edi, eax
            //   72bb                 | jb                  0xffffffbd

    condition:
        7 of them and filesize < 331776
}