rule win_lemonduck_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lemonduck."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lemonduck"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4c8d65c0 4c89642440 8918 33c0 89442434 eb02 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d65c0             | dec                 eax
            //   4c89642440           | mov                 ecx, eax
            //   8918                 | dec                 eax
            //   33c0                 | lea                 edx, [0x654a9]
            //   89442434             | dec                 eax
            //   eb02                 | mov                 eax, dword ptr [esp + 0x48]

        $sequence_1 = { 90 33c9 48894dd0 48894dd8 41bf05040000 6644897dde 488b4dd8 }
            // n = 7, score = 100
            //   90                   | nop                 
            //   33c9                 | movups              xmm0, xmmword ptr [eax]
            //   48894dd0             | movups              xmmword ptr [ecx + eax], xmm0
            //   48894dd8             | movups              xmm1, xmmword ptr [eax + 0x10]
            //   41bf05040000         | movups              xmmword ptr [ecx + eax + 0x10], xmm1
            //   6644897dde           | movups              xmm0, xmmword ptr [eax + 0x20]
            //   488b4dd8             | movups              xmmword ptr [ecx + eax + 0x20], xmm0

        $sequence_2 = { eb03 0f57c9 488b05???????? f20f110d???????? 4885c0 7422 488d157ddf0000 }
            // n = 7, score = 100
            //   eb03                 | dec                 ecx
            //   0f57c9               | xchg                dword ptr [esi + esi*8 + 0x19e8b0], eax
            //   488b05????????       |                     
            //   f20f110d????????     |                     
            //   4885c0               | jmp                 0x7c
            //   7422                 | xor                 ebx, ebx
            //   488d157ddf0000       | dec                 esp

        $sequence_3 = { ffe0 488d0503f60a00 c3 488d05e3f50a00 c3 488d05c3f50a00 c3 }
            // n = 7, score = 100
            //   ffe0                 | jne                 0xb04
            //   488d0503f60a00       | call                eax
            //   c3                   | inc                 esp
            //   488d05e3f50a00       | mov                 esi, eax
            //   c3                   | test                eax, eax
            //   488d05c3f50a00       | jns                 0x7c3
            //   c3                   | cmp                 dword ptr [eax], 0x28

        $sequence_4 = { b83f000000 e9???????? 4898 498b0cc7 48890d???????? 488d153f9d1500 c744242000000000 }
            // n = 7, score = 100
            //   b83f000000           | cmp                 dl, 9
            //   e9????????           |                     
            //   4898                 | inc                 ecx
            //   498b0cc7             | cmova               eax, edx
            //   48890d????????       |                     
            //   488d153f9d1500       | add                 al, dl
            //   c744242000000000     | inc                 ecx

        $sequence_5 = { f30f6f4ff0 4c8d4d90 4889442440 4c8d4580 660fefc2 488d442450 660fefcb }
            // n = 7, score = 100
            //   f30f6f4ff0           | movdqu              xmmword ptr [ecx + esi], xmm0
            //   4c8d4d90             | movdqu              xmm2, xmmword ptr [eax + esi]
            //   4889442440           | movdqu              xmm1, xmmword ptr [ecx + esi]
            //   4c8d4580             | paddq               xmm2, xmm4
            //   660fefc2             | punpcklqdq          xmm6, xmm0
            //   488d442450           | movdqu              xmm0, xmmword ptr [edx + esi]
            //   660fefcb             | inc                 cx

        $sequence_6 = { e8???????? 90 e8???????? 90 e8???????? cc 4c8bdc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | mov                 edx, dword ptr [esi + 0x10]
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   e8????????           |                     
            //   cc                   | sub                 edx, ecx
            //   4c8bdc               | nop                 

        $sequence_7 = { e8???????? 488b8fb8000000 e8???????? 488b8fc0000000 e8???????? 488b8fc8000000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b8fb8000000       | jb                  0x221
            //   e8????????           |                     
            //   488b8fc0000000       | dec                 eax
            //   e8????????           |                     
            //   488b8fc8000000       | mov                 ebx, dword ptr [esp + 0x20]
            //   e8????????           |                     

        $sequence_8 = { 66410fefc9 f3430f7f0c2a 660f6f4590 660f38dc442440 660f7f4590 66410fefc2 f30f7f00 }
            // n = 7, score = 100
            //   66410fefc9           | paddq               mm2, mm0
            //   f3430f7f0c2a         | inc                 edx
            //   660f6f4590           | movq                mm1, qword ptr [eax + edi]
            //   660f38dc442440       | inc                 ecx
            //   660f7f4590           | and                 esp, 0x1ffff0
            //   66410fefc2           | inc                 ebx
            //   f30f7f00             | movq                mm0, qword ptr [esp + edi]

        $sequence_9 = { eb22 488d1d912c1400 eb19 488d1d702c1400 eb10 488d1d9f2c1400 eb07 }
            // n = 7, score = 100
            //   eb22                 | mov                 edx, eax
            //   488d1d912c1400       | dec                 eax
            //   eb19                 | lea                 ecx, [0x197667]
            //   488d1d702c1400       | mov                 ecx, dword ptr [eax - 0x14]
            //   eb10                 | jmp                 0x274
            //   488d1d9f2c1400       | dec                 esp
            //   eb07                 | lea                 eax, [esp + 0x28]

    condition:
        7 of them and filesize < 10011648
}