rule win_locky_decryptor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.locky_decryptor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.locky_decryptor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 834424181c 43 3bdf 7cd2 8b4510 3944243c }
            // n = 6, score = 100
            //   834424181c           | add                 dword ptr [esp + 0x18], 0x1c
            //   43                   | inc                 ebx
            //   3bdf                 | cmp                 ebx, edi
            //   7cd2                 | jl                  0xffffffd4
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   3944243c             | cmp                 dword ptr [esp + 0x3c], eax

        $sequence_1 = { e8???????? ff15???????? 50 8d8578ffffff 50 8d45cc e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   50                   | push                eax
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   e8????????           |                     

        $sequence_2 = { 57 ff750c 8d742414 e8???????? }
            // n = 4, score = 100
            //   57                   | push                edi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8d742414             | lea                 esi, [esp + 0x14]
            //   e8????????           |                     

        $sequence_3 = { e8???????? ff15???????? 50 8d442448 50 8d442414 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d442448             | lea                 eax, [esp + 0x48]
            //   50                   | push                eax
            //   8d442414             | lea                 eax, [esp + 0x14]

        $sequence_4 = { e8???????? 8bc6 5d c20400 c3 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   c3                   | ret                 

        $sequence_5 = { 37 46 37 61 37 }
            // n = 5, score = 100
            //   37                   | aaa                 
            //   46                   | inc                 esi
            //   37                   | aaa                 
            //   61                   | popal               
            //   37                   | aaa                 

        $sequence_6 = { 64a100000000 50 64892500000000 83ec78 8b4510 53 8b5d0c }
            // n = 7, score = 100
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   83ec78               | sub                 esp, 0x78
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   53                   | push                ebx
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]

        $sequence_7 = { 84c0 7403 ff45ec ff45e8 6a01 33ff 8d7594 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   7403                 | je                  5
            //   ff45ec               | inc                 dword ptr [ebp - 0x14]
            //   ff45e8               | inc                 dword ptr [ebp - 0x18]
            //   6a01                 | push                1
            //   33ff                 | xor                 edi, edi
            //   8d7594               | lea                 esi, [ebp - 0x6c]

        $sequence_8 = { 59 6a01 33ff 8db578ffffff e8???????? }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   6a01                 | push                1
            //   33ff                 | xor                 edi, edi
            //   8db578ffffff         | lea                 esi, [ebp - 0x88]
            //   e8????????           |                     

        $sequence_9 = { c745c007000000 668945ac e8???????? ff75e4 8365fc00 8d45c8 e8???????? }
            // n = 7, score = 100
            //   c745c007000000       | mov                 dword ptr [ebp - 0x40], 7
            //   668945ac             | mov                 word ptr [ebp - 0x54], ax
            //   e8????????           |                     
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 278528
}