rule win_lokipws_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lokipws."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lokipws"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 6a00 57 e8???????? 6a0c }
            // n = 5, score = 300
            //   56                   | push                esi
            //   6a00                 | push                0
            //   57                   | push                edi
            //   e8????????           |                     
            //   6a0c                 | push                0xc

        $sequence_1 = { e8???????? 33c0 83c418 40 c3 6a00 6a00 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   83c418               | add                 esp, 0x18
            //   40                   | inc                 eax
            //   c3                   | ret                 
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_2 = { 8945f4 8b4514 6a00 ff7518 8945f8 8d45f8 8365fc00 }
            // n = 7, score = 300
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   6a00                 | push                0
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0

        $sequence_3 = { 53 e8???????? 59 59 85c0 7564 8d8530ffffff }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7564                 | jne                 0x66
            //   8d8530ffffff         | lea                 eax, [ebp - 0xd0]

        $sequence_4 = { 56 57 6800040000 e8???????? c70424???????? be???????? 6a00 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   6800040000           | push                0x400
            //   e8????????           |                     
            //   c70424????????       |                     
            //   be????????           |                     
            //   6a00                 | push                0

        $sequence_5 = { 51 ffd0 33c0 50 50 57 }
            // n = 6, score = 300
            //   51                   | push                ecx
            //   ffd0                 | call                eax
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_6 = { 58 6a66 5f 6a25 668945f6 33c0 668945fc }
            // n = 7, score = 300
            //   58                   | pop                 eax
            //   6a66                 | push                0x66
            //   5f                   | pop                 edi
            //   6a25                 | push                0x25
            //   668945f6             | mov                 word ptr [ebp - 0xa], ax
            //   33c0                 | xor                 eax, eax
            //   668945fc             | mov                 word ptr [ebp - 4], ax

        $sequence_7 = { 895dec ff75fc c745f005000000 ff75f4 56 e8???????? 83c420 }
            // n = 7, score = 300
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   c745f005000000       | mov                 dword ptr [ebp - 0x10], 5
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20

        $sequence_8 = { 8b7810 8b5910 0f849e000000 83651000 8d7510 }
            // n = 5, score = 300
            //   8b7810               | mov                 edi, dword ptr [eax + 0x10]
            //   8b5910               | mov                 ebx, dword ptr [ecx + 0x10]
            //   0f849e000000         | je                  0xa4
            //   83651000             | and                 dword ptr [ebp + 0x10], 0
            //   8d7510               | lea                 esi, [ebp + 0x10]

        $sequence_9 = { 8bec 83ec0c 56 6a04 e8???????? 8bf0 }
            // n = 6, score = 300
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc
            //   56                   | push                esi
            //   6a04                 | push                4
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

    condition:
        7 of them and filesize < 1327104
}