rule win_loup_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.loup."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.loup"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 85c0 741c 0fb745f4 50 e8???????? }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   741c                 | je                  0x1e
            //   0fb745f4             | movzx               eax, word ptr [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 81781422059319 740c 8b4dfc 81791400409901 7522 e8???????? 8b55fc }
            // n = 7, score = 100
            //   81781422059319       | cmp                 dword ptr [eax + 0x14], 0x19930522
            //   740c                 | je                  0xe
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   81791400409901       | cmp                 dword ptr [ecx + 0x14], 0x1994000
            //   7522                 | jne                 0x24
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_2 = { 85c0 0f84da000000 8b7dec 8b07 8b7068 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f84da000000         | je                  0xe0
            //   8b7dec               | mov                 edi, dword ptr [ebp - 0x14]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b7068               | mov                 esi, dword ptr [eax + 0x68]

        $sequence_3 = { 8b85d0f1ffff 53 56 ff3485647b4100 50 }
            // n = 5, score = 100
            //   8b85d0f1ffff         | mov                 eax, dword ptr [ebp - 0xe30]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff3485647b4100       | push                dword ptr [eax*4 + 0x417b64]
            //   50                   | push                eax

        $sequence_4 = { 68c0d40100 8d4de8 51 682e010000 0fb75508 52 e8???????? }
            // n = 7, score = 100
            //   68c0d40100           | push                0x1d4c0
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   51                   | push                ecx
            //   682e010000           | push                0x12e
            //   0fb75508             | movzx               edx, word ptr [ebp + 8]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_5 = { 81f247656e75 b804000000 6bc803 8b440de0 35696e6549 }
            // n = 5, score = 100
            //   81f247656e75         | xor                 edx, 0x756e6547
            //   b804000000           | mov                 eax, 4
            //   6bc803               | imul                ecx, eax, 3
            //   8b440de0             | mov                 eax, dword ptr [ebp + ecx - 0x20]
            //   35696e6549           | xor                 eax, 0x49656e69

        $sequence_6 = { 8b4df4 84c0 0f84defeffff c745dc01000000 e9???????? 5f 5e }
            // n = 7, score = 100
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   84c0                 | test                al, al
            //   0f84defeffff         | je                  0xfffffee4
            //   c745dc01000000       | mov                 dword ptr [ebp - 0x24], 1
            //   e9????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 668945e8 33c0 668945ea c745ee01000000 b804000000 668945ec }
            // n = 6, score = 100
            //   668945e8             | mov                 word ptr [ebp - 0x18], ax
            //   33c0                 | xor                 eax, eax
            //   668945ea             | mov                 word ptr [ebp - 0x16], ax
            //   c745ee01000000       | mov                 dword ptr [ebp - 0x12], 1
            //   b804000000           | mov                 eax, 4
            //   668945ec             | mov                 word ptr [ebp - 0x14], ax

        $sequence_8 = { b804000000 c1e002 c784055cffffff01000000 8d855cffffff 8945d5 }
            // n = 5, score = 100
            //   b804000000           | mov                 eax, 4
            //   c1e002               | shl                 eax, 2
            //   c784055cffffff01000000     | mov    dword ptr [ebp + eax - 0xa4], 1
            //   8d855cffffff         | lea                 eax, [ebp - 0xa4]
            //   8945d5               | mov                 dword ptr [ebp - 0x2b], eax

        $sequence_9 = { 8915???????? c705????????01000000 a1???????? 83c802 a3???????? b904000000 c1e100 }
            // n = 7, score = 100
            //   8915????????         |                     
            //   c705????????01000000     |     
            //   a1????????           |                     
            //   83c802               | or                  eax, 2
            //   a3????????           |                     
            //   b904000000           | mov                 ecx, 4
            //   c1e100               | shl                 ecx, 0

    condition:
        7 of them and filesize < 257024
}