rule win_magala_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.magala."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.magala"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf8 c7461000000000 c746140f000000 c60600 837f1410 }
            // n = 5, score = 200
            //   8bf8                 | mov                 edi, eax
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   c60600               | mov                 byte ptr [esi], 0
            //   837f1410             | cmp                 dword ptr [edi + 0x14], 0x10

        $sequence_1 = { 57 51 8bf9 c785e8feffff00000000 50 }
            // n = 5, score = 200
            //   57                   | push                edi
            //   51                   | push                ecx
            //   8bf9                 | mov                 edi, ecx
            //   c785e8feffff00000000     | mov    dword ptr [ebp - 0x118], 0
            //   50                   | push                eax

        $sequence_2 = { 8b450c ff7508 03c3 03c2 50 8b4510 03c3 }
            // n = 7, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   03c3                 | add                 eax, ebx
            //   03c2                 | add                 eax, edx
            //   50                   | push                eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   03c3                 | add                 eax, ebx

        $sequence_3 = { 8bfb 8b75c4 85f6 7432 8b4dcc b853d9de75 2bce }
            // n = 7, score = 200
            //   8bfb                 | mov                 edi, ebx
            //   8b75c4               | mov                 esi, dword ptr [ebp - 0x3c]
            //   85f6                 | test                esi, esi
            //   7432                 | je                  0x34
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   b853d9de75           | mov                 eax, 0x75ded953
            //   2bce                 | sub                 ecx, esi

        $sequence_4 = { 8985ecfdffff ff15???????? 8bf0 89b5f0fdffff 85f6 0f847f000000 }
            // n = 6, score = 200
            //   8985ecfdffff         | mov                 dword ptr [ebp - 0x214], eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   89b5f0fdffff         | mov                 dword ptr [ebp - 0x210], esi
            //   85f6                 | test                esi, esi
            //   0f847f000000         | je                  0x85

        $sequence_5 = { 8bf1 0f42f8 8b4e10 8bc1 f7d0 3bc7 0f86de000000 }
            // n = 7, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   0f42f8               | cmovb               edi, eax
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   8bc1                 | mov                 eax, ecx
            //   f7d0                 | not                 eax
            //   3bc7                 | cmp                 eax, edi
            //   0f86de000000         | jbe                 0xe4

        $sequence_6 = { 8bf0 3bfe 7445 8bcf e8???????? }
            // n = 5, score = 200
            //   8bf0                 | mov                 esi, eax
            //   3bfe                 | cmp                 edi, esi
            //   7445                 | je                  0x47
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     

        $sequence_7 = { e8???????? 8b06 83c408 5e 85c0 7510 68???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83c408               | add                 esp, 8
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12
            //   68????????           |                     

        $sequence_8 = { 0f1f440000 56 68???????? e8???????? }
            // n = 4, score = 200
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   56                   | push                esi
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_9 = { 8955fc 7202 8b00 837f1410 7204 8b0f eb02 }
            // n = 7, score = 200
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   837f1410             | cmp                 dword ptr [edi + 0x14], 0x10
            //   7204                 | jb                  6
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   eb02                 | jmp                 4

    condition:
        7 of them and filesize < 589824
}