rule win_mail_o_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mail_o."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mail_o"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 83a3980e0000fd 4889bb800e0000 488bcb 4889bb800e0000 e8???????? 488b8b60100000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83a3980e0000fd       | jne                 0x1ffe
            //   4889bb800e0000       | mov                 dword ptr [esp + 0x28], 0x8d7
            //   488bcb               | dec                 eax
            //   4889bb800e0000       | mov                 ecx, ebx
            //   e8????????           |                     
            //   488b8b60100000       | dec                 eax

        $sequence_1 = { ffc7 4883c302 493bde 7cd7 488b8c24a0000000 ba01000000 448d42fe }
            // n = 7, score = 100
            //   ffc7                 | xor                 eax, eax
            //   4883c302             | dec                 eax
            //   493bde               | mov                 ecx, ebx
            //   7cd7                 | dec                 eax
            //   488b8c24a0000000     | mov                 edx, dword ptr [esp + 0x60]
            //   ba01000000           | dec                 eax
            //   448d42fe             | mov                 ecx, ebx

        $sequence_2 = { eb2e 488d15518b1500 488bcf e8???????? 85c0 7405 830b02 }
            // n = 7, score = 100
            //   eb2e                 | add                 esp, 0x30
            //   488d15518b1500       | pop                 edi
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 ecx, dword ptr [ebx + 0x578]
            //   7405                 | lea                 edx, [eax + 0x5c]
            //   830b02               | dec                 eax

        $sequence_3 = { e8???????? 8bf8 85c0 7563 488d15563e1700 488bcb e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edx, ebx
            //   85c0                 | dec                 eax
            //   7563                 | mov                 dword ptr [esp + 0x20], eax
            //   488d15563e1700       | inc                 ecx
            //   488bcb               | mov                 ecx, 8
            //   e8????????           |                     

        $sequence_4 = { f30fe6d2 8bd7 e8???????? 03ef 85db 7ea1 2bdf }
            // n = 7, score = 100
            //   f30fe6d2             | dec                 eax
            //   8bd7                 | mov                 dword ptr [esp + 0xd8], eax
            //   e8????????           |                     
            //   03ef                 | dec                 eax
            //   85db                 | mov                 ebx, dword ptr [esp + 0x158]
            //   7ea1                 | mov                 eax, edi
            //   2bdf                 | dec                 eax

        $sequence_5 = { 7cda 488b4f20 488bd6 e8???????? 4885c0 0f8459020000 418bec }
            // n = 7, score = 100
            //   7cda                 | inc                 ecx
            //   488b4f20             | cmp                 bh, 1
            //   488bd6               | jne                 0x924
            //   e8????????           |                     
            //   4885c0               | dec                 eax
            //   0f8459020000         | mov                 ecx, esi
            //   418bec               | inc                 esp

        $sequence_6 = { e9???????? 4183fd00 743e 492bed 4d8bc5 488bd5 488bcf }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4183fd00             | mov                 eax, 5
            //   743e                 | dec                 eax
            //   492bed               | lea                 edx, [esp + 0x48]
            //   4d8bc5               | dec                 eax
            //   488bd5               | mov                 ecx, edi
            //   488bcf               | dec                 eax

        $sequence_7 = { e8???????? b8ffffffff e9???????? 448b8c24a0000000 4183f901 746a 4c8d0578650900 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b8ffffffff           | add                 esp, 0x48
            //   e9????????           |                     
            //   448b8c24a0000000     | inc                 ecx
            //   4183f901             | pop                 esi
            //   746a                 | pop                 edi
            //   4c8d0578650900       | pop                 esi

        $sequence_8 = { bfffffffff e9???????? f7432000010000 4889742440 740f 488bd3 488d0da3050000 }
            // n = 7, score = 100
            //   bfffffffff           | dec                 eax
            //   e9????????           |                     
            //   f7432000010000       | mov                 ecx, ebp
            //   4889742440           | dec                 eax
            //   740f                 | mov                 ebx, eax
            //   488bd3               | inc                 ecx
            //   488d0da3050000       | mov                 eax, 0x46

        $sequence_9 = { 7442 488bce 4c8d2defdb0b00 0f1f4000 6666660f1f840000000000 410fb61408 48ffc1 }
            // n = 7, score = 100
            //   7442                 | inc                 ecx
            //   488bce               | mov                 eax, 0x3a
            //   4c8d2defdb0b00       | dec                 eax
            //   0f1f4000             | lea                 edx, [0x14d0bf]
            //   6666660f1f840000000000     | inc    ecx
            //   410fb61408           | lea                 ecx, [eax - 0x1a]
            //   48ffc1               | inc                 ecx

    condition:
        7 of them and filesize < 5985280
}